import argparse
import json
import ntpath
import os
import sys
from graphviz import Digraph

from sources.imprecise_analysis.ModuleParser import ModuleParser
from sources.representation.ARParser import PY_EXTENSION

SEMI_COLON = ";"
COLON = ':'
DOT = ".dot"


def save_imports_file(imports_map, file_name):
    with open(file_name, 'w') as outfile:
        json.dump(imports_map, outfile, indent=2)


def save_dot_file(graph_string, file_name):
    with open(file_name, "w") as text_file:
        text_file.write(graph_string)


def empty_directory(folder):
    import os
    for the_file in os.listdir(folder):
        file_path = os.path.join(folder, the_file)
        try:
            if os.path.isfile(file_path):
                os.unlink(file_path)
                # elif os.path.isdir(file_path): shutil.rmtree(file_path)#recursive
        except Exception as e:
            print(e)


def export_module_dot(dir_module_relative, export_dir, site_packages):
    dir_module = os.path.abspath(dir_module_relative)
    site_packages = {k.lower(): v for k, v in site_packages.items()}
    module_parser = ModuleParser(site_packages)
    log_dir = os.path.join(export_dir, "..")
    transitive_dependencies = module_parser.analyze_transitive_dependencies(dir_module, log_dir)
    dots = module_parser.dots
    if not os.path.exists(export_dir):
        os.makedirs(export_dir)
    empty_directory(export_dir)
    imports = module_parser.imports
    imports_dir = os.path.abspath(os.path.join(export_dir, ".." + os.sep + "data"))
    if not os.path.exists(imports_dir):
        os.makedirs(imports_dir)
    save_imports_file(imports, os.path.join(imports_dir, "imports.json"))
    for module_name in dots:
        file_name = os.path.join(export_dir, ntpath.basename(module_name) + DOT)
        if module_name in site_packages:
            dir_path = site_packages[module_name]
        else:
            dir_path = dir_module
        g = Digraph(file_name, format='dot', comment='Path: ' + os.path.abspath(dir_path), filename=file_name)
        for arc in dots[module_name]:
            for dest in dots[module_name][arc]:
                destination_without_colon = dest.replace(COLON, SEMI_COLON)
                if is_single_file_module(module_name, site_packages):
                    src = arc
                else:
                    src = module_name + os.sep + arc
                g.edge(src, destination_without_colon)
        save_dot_file(g.source.replace(SEMI_COLON, COLON), file_name)
    return (module_parser.app_parse_errors, module_parser.ext_parse_errors, module_parser.errors)


def is_single_file_module(module_name, site_packages):
    return module_name in site_packages and site_packages[module_name].endswith(
        PY_EXTENSION)


def main():
    parser = argparse.ArgumentParser("Dot Exporter - pydeps ")
    parser.add_argument('-d', '--dir_module', required=True, help="path to app folder",
                        type=lambda x: is_valid_file(parser, x))
    parser.add_argument('-e', '--export_dir', required=True, help="path to dot_export folder",
                        type=lambda x: is_valid_file(parser, x))
    parser.add_argument('-s', '--site_packages', required=True, help="path to site_packages json file",
                        type=lambda x: is_valid_file(parser, x))

    # export_args(r"C:\Users\eugen\AppData\Local\Temp\whitesource6446526394787069713\out\site_packages.json",
    #             r"C:\repos\ws7\via\whitesourceanalysisviatesting\test_inputs\python_tests\faker-test",
    #             r"C:\Users\eugen\AppData\Local\Temp\whitesource6446526394787069713\dots")

    args = parser.parse_args()
    export_args(args.site_packages, args.dir_module, args.export_dir)


def export_args(site_packages_file, dir_module, export_dir):
    with open(site_packages_file) as f:
        site_packages = json.load(f)
        (app_syntax_error, ext_syntax_error, error) = export_module_dot(dir_module, export_dir, site_packages)
        if error:
            sys.exit(1)
        if app_syntax_error:
            sys.exit(2)
        if ext_syntax_error:
            sys.exit(3)


def is_valid_file(parser, arg):
    if not os.path.exists(arg):
        parser.error("Invalid file %s" % arg)
    else:
        return arg


if __name__ == '__main__':
    sys.exit(main())
