"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _helperPluginUtils = require("@babel/helper-plugin-utils");

const entries = new Set(["Get", "Post", "Put", "Delete", "Patch", "Options", "Head", "All"]);


var _default = (0, _helperPluginUtils.declare) ( api => {
  return {
    visitor: {

      ClassDeclaration(classDeclarationPath) {

        //Check if this class has the @Dependencies annotation
        var depArray = getClassDependencies(classDeclarationPath);
        if (depArray){
          const constructorNode = getClassConstructorNode(classDeclarationPath);
          if (constructorNode && constructorNode.params){
            for(var i=0 ; i<depArray.length ; i++){

              if (constructorNode.params[i]) {
                var type = depArray[i];
                var name = constructorNode.params[i].name;
                var line = null;
                if (constructorNode.loc &&
                    constructorNode.loc.start &&
                    constructorNode.loc.start.line){
                  line = constructorNode.loc.start.line;
                }

                saveDecTypeInfo(classDeclarationPath, type, name, line);
              }
            }

          }
        }

        //Check if this class is a NestJS Controller
        if (isClassController(classDeclarationPath)) {

          //If it is a controller --> Save the list of entries of this contorller
          if (classDeclarationPath.node && 
              classDeclarationPath.node.body && 
              classDeclarationPath.node.body.body){
            const classBody = classDeclarationPath.node.body.body;
            for (const methodNode of classBody){
              if (isEntry(methodNode)){
                saveEntryInfo(classDeclarationPath, methodNode);
              }
            }
          }

        }
      },

      Identifier(path) {
        if (path.node &&
            path.node.typeAnnotation &&
            path.node.typeAnnotation.typeAnnotation){

          var type;
          if (path.node.typeAnnotation.typeAnnotation.typeName) {
            type = path.node.typeAnnotation.typeAnnotation.typeName.name;
          }
          else {
            type = path.node.typeAnnotation.typeAnnotation.type
          }

          const name = path.node.name;

          var line = null;
          if (path.node.loc && path.node.loc.start && path.node.loc.start.line) {
            line = path.node.loc.start.line;
          }

          saveDecTypeInfo(path, type, name, line);
        }
      },

      ImportDeclaration(path) {
        // The `path` object contains information about the import declaration
        const source = path.node.source.value; // The module path

        // You can access and manipulate other information as needed
        // For example, you can get information about imported specifiers
        const specifiers = path.node.specifiers;

        // Your custom logic for handling import statements
        specifiers.map(spec => saveImportDeclaration(path, spec.local.name, source));
      }

    },
  };
});

function getClassConstructorNode(classDeclarationPath){
  if (classDeclarationPath && 
      classDeclarationPath.node &&
      classDeclarationPath.node.body &&
      classDeclarationPath.node.body.body) {
    
    for (const node of classDeclarationPath.node.body.body) {
      if (node.type &&
          node.type === "ClassMethod" &&
          node.key &&
          node.key.name && 
          node.key.name === "constructor") {
        return node;
      }
    }
  }

  return null;
}

function getClassDependencies(classDeclarationPath){

  if (classDeclarationPath && 
      classDeclarationPath.node && 
      classDeclarationPath.node.decorators) {

    const classDecorators = classDeclarationPath.node.decorators;
    for (const decorator of classDecorators) {
      const decoratorName = getDecoratorName(decorator);
      if (decoratorName &&
          decoratorName === "Dependencies" &&
          decorator.expression &&
          decorator.expression.arguments) {

        const depArray = [];

        for (const argument of decorator.expression.arguments) {
          if (argument.name) {
            depArray.push(argument.name);
          }
        }

        return depArray;
      }
    }
  }

  return null;
}

function isClassController(classDeclarationPath){

  if (classDeclarationPath && 
      classDeclarationPath.node && 
      classDeclarationPath.node.decorators){

    const classDecorators = classDeclarationPath.node.decorators;
    for(const decorator of classDecorators) {
      const decoratorName = getDecoratorName(decorator);
      if (decoratorName && decoratorName === "Controller"){
        return true;
      }
    }
  }

  return false;
  
}

function getDecoratorName(decorator){
  if (
      decorator &&
      decorator.expression &&
      decorator.expression.callee &&
      decorator.expression.callee.loc &&
      decorator.expression.callee.loc.identifierName ){
    return decorator.expression.callee.loc.identifierName;
  }

  return null;
}

function isEntry(methodNode){

  if (methodNode && methodNode.decorators){
    for (const decorator of methodNode.decorators) {
      const name = getDecoratorName(decorator);
      if (name && entries.has(name)){
        return true;
      }
    }
  }

  return false;
}

function getRootPath(path){
  var result = path;
  while(result.parentPath != null){
    result = result.parentPath;
  }
  return result;
}

function saveEntryInfo(pathclassDeclarationPath, methodNode){

  const rootPath = getRootPath(pathclassDeclarationPath);

  if (rootPath &&
      rootPath.hub &&
      rootPath.hub.file &&
      methodNode &&
      methodNode.key &&
      methodNode.key.loc &&
      methodNode.key.loc.start ) {

    const file = rootPath.hub.file;

    if (!file.metadata){
      file.metadata = {};
    }

    if (!file.metadata.customInfo) {
      file.metadata.customInfo = {};
    }

    if (!file.metadata.customInfo.nestEntries) {
      file.metadata.customInfo.nestEntries = [];
    }

    file.metadata.customInfo.nestEntries.push(methodNode.key.loc.start);
  }

}

function saveDecTypeInfo(path, type, name, line) {

  if (type) {
    const rootPath = getRootPath(path);
    const file = rootPath.hub.file;

    if (!file.metadata.customInfo) {
      file.metadata.customInfo = {};
    }

    if (!file.metadata.customInfo.decTypes) {
      file.metadata.customInfo.decTypes = [];
    }

    var decType = {};
    decType.type = type;
    decType.name = name;
    decType.line = line;
    file.metadata.customInfo.decTypes.push(decType);
  }
}

function saveImportDeclaration(path, specifier, source) {

  if (specifier && source) {
    const rootPath = getRootPath(path);
    const file = rootPath.hub.file;

    if (!file.metadata.customInfo) {
      file.metadata.customInfo = {};
    }

    if (!file.metadata.customInfo.importDeclarationMap) {
      file.metadata.customInfo.importDeclarationMap = new Map();
    }

    file.metadata.customInfo.importDeclarationMap.set(specifier, source);
  }
}


exports.default = _default;
