package com.wss.scanner.registry.utils.filesParsers;

import javax.xml.XMLConstants;
import javax.xml.parsers.*;
import java.io.File;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.wss.common.logging.LogContext;
import com.wss.common.logging.LogUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XmlParser {

    /* --- Private Static Fields --- */
    private final static Logger logger = LoggerFactory.getLogger(XmlParser.class);

    /* --- Private Fields --- */

    /* --- Constructors --- */
    public XmlParser() {
    }

    /* --- Public Methods --- */

    /**
     * This method is for parsing xml files and returning the content as a Document object
     * @param logContext - the log context
     * @param filePath   - the xml file path
     * @return Document object holding the content of the xml file
     */
    public Document parseXmlFile(LogContext logContext, String filePath, boolean isFilePath) {
        logger.debug(LogUtils.formatLogMessage(logContext, this.getClass().getName() +
                " - parseXmlFile - START - settings.xml file at: {} "), filePath);
        Document doc = null;
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            // process XML securely, avoid attacks like XML External Entities (XXE)
            dbFactory.setFeature(XMLConstants.FEATURE_SECURE_PROCESSING, true);

            // parse XML file
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();

            if (isFilePath) {
                doc = dBuilder.parse(new File(filePath));
            } else {
                doc = dBuilder.parse(filePath);
            }

            doc.getDocumentElement().normalize();
        } catch (Exception e) {
            logger.error(LogUtils.getExceptionErrorMessage(logContext, e, this.getClass().getName() +
                    " - parseXmlFile - error while parsing the xml file "));
        }

        return doc;
    }

    /**
     * removing all indentation text nodes from document before writing to file.
     * @param node
     */
    public void removeEmptyText(Node node){
        Node child = node.getFirstChild();
        while (child != null){
            Node sibling = child.getNextSibling();
            if (child.getNodeType() == Node.TEXT_NODE) {
                if (child.getTextContent().trim().isEmpty()) {
                    node.removeChild(child);
                }
            } else {
                removeEmptyText(child);
            }
            child = sibling;
        }
    }

    /* --- Private Methods --- */

}