package com.wss.github.scanner.api.dto;


import java.io.Serializable;

public class SourceControlScanParams implements Serializable {

    /* --- Static members --- */

    private static final long serialVersionUID = -5525231527012656795L;

    /* --- Members --- */

    private boolean npmRunPreStep;
    private boolean npmResolveDependencies;
    private boolean npmIncludeDevDependencies;
    private boolean npmIgnoreJavaScriptFiles;
    private long npmTimeoutDependenciesCollector;
    private boolean npmIgnoreNpmLsErrors;
    private boolean bowerResolveDependencies;
    private boolean bowerRunPreStep;
    private boolean nugetResolveDependencies;
    private boolean mavenResolveDependencies;
    private String mavenIgnoredScopes;
    private boolean mavenAggregateModules;
    private boolean pythonResolveDependencies;
    private String pipPath;
    private String pythonPath;
    private boolean pythonIsWssPluginInstalled;
    private boolean pythonUninstallWssPlugin;
    private boolean dependenciesOnly;

    /* --- Constructors --- */

    public SourceControlScanParams(boolean npmRunPreStep, boolean npmResolveDependencies, boolean npmIncludeDevDependencies, boolean npmIgnoreJavaScriptFiles, long npmTimeoutDependenciesCollector, boolean npmIgnoreNpmLsErrors, boolean bowerResolveDependencies, boolean bowerRunPreStep, boolean nugetResolveDependencies, boolean mavenResolveDependencies, String mavenIgnoredScopes, boolean mavenAggregateModules, boolean pythonResolveDependencies, String pipPath, String pythonPath, boolean pythonIsWssPluginInstalled, boolean pythonUninstallWssPlugin, boolean dependenciesOnly) {
        this.npmRunPreStep = npmRunPreStep;
        this.npmResolveDependencies = npmResolveDependencies;
        this.npmIncludeDevDependencies = npmIncludeDevDependencies;
        this.npmIgnoreJavaScriptFiles = npmIgnoreJavaScriptFiles;
        this.npmTimeoutDependenciesCollector = npmTimeoutDependenciesCollector;
        this.npmIgnoreNpmLsErrors = npmIgnoreNpmLsErrors;
        this.bowerResolveDependencies = bowerResolveDependencies;
        this.bowerRunPreStep = bowerRunPreStep;
        this.nugetResolveDependencies = nugetResolveDependencies;
        this.mavenResolveDependencies = mavenResolveDependencies;
        this.mavenIgnoredScopes = mavenIgnoredScopes;
        this.mavenAggregateModules = mavenAggregateModules;
        this.pythonResolveDependencies = pythonResolveDependencies;
        this.pipPath = pipPath;
        this.pythonPath = pythonPath;
        this.pythonIsWssPluginInstalled = pythonIsWssPluginInstalled;
        this.pythonUninstallWssPlugin = pythonUninstallWssPlugin;
        this.dependenciesOnly = dependenciesOnly;
    }

    public SourceControlScanParams() {
    }

    /* --- Getters / Setters --- */

    public boolean isNpmRunPreStep() {
        return npmRunPreStep;
    }

    public void setNpmRunPreStep(boolean npmRunPreStep) {
        this.npmRunPreStep = npmRunPreStep;
    }

    public boolean isNpmResolveDependencies() {
        return npmResolveDependencies;
    }

    public void setNpmResolveDependencies(boolean npmResolveDependencies) {
        this.npmResolveDependencies = npmResolveDependencies;
    }

    public boolean isNpmIncludeDevDependencies() {
        return npmIncludeDevDependencies;
    }

    public void setNpmIncludeDevDependencies(boolean npmIncludeDevDependencies) {
        this.npmIncludeDevDependencies = npmIncludeDevDependencies;
    }

    public boolean isNpmIgnoreJavaScriptFiles() {
        return npmIgnoreJavaScriptFiles;
    }

    public void setNpmIgnoreJavaScriptFiles(boolean npmIgnoreJavaScriptFiles) {
        this.npmIgnoreJavaScriptFiles = npmIgnoreJavaScriptFiles;
    }

    public long getNpmTimeoutDependenciesCollector() {
        return npmTimeoutDependenciesCollector;
    }

    public void setNpmTimeoutDependenciesCollector(long npmTimeoutDependenciesCollector) {
        this.npmTimeoutDependenciesCollector = npmTimeoutDependenciesCollector;
    }

    public boolean isBowerResolveDependencies() {
        return bowerResolveDependencies;
    }

    public void setBowerResolveDependencies(boolean bowerResolveDependencies) {
        this.bowerResolveDependencies = bowerResolveDependencies;
    }

    public boolean isBowerRunPreStep() {
        return bowerRunPreStep;
    }

    public void setBowerRunPreStep(boolean bowerRunPreStep) {
        this.bowerRunPreStep = bowerRunPreStep;
    }

    public boolean isNugetResolveDependencies() {
        return nugetResolveDependencies;
    }

    public void setNugetResolveDependencies(boolean nugetResolveDependencies) {
        this.nugetResolveDependencies = nugetResolveDependencies;
    }

    public boolean isMavenResolveDependencies() {
        return mavenResolveDependencies;
    }

    public void setMavenResolveDependencies(boolean mavenResolveDependencies) {
        this.mavenResolveDependencies = mavenResolveDependencies;
    }

    public String getMavenIgnoredScopes() {
        return mavenIgnoredScopes;
    }

    public void setMavenIgnoredScopes(String mavenIgnoredScopes) {
        this.mavenIgnoredScopes = mavenIgnoredScopes;
    }

    public boolean isMavenAggregateModules() {
        return mavenAggregateModules;
    }

    public void setMavenAggregateModules(boolean mavenAggregateModules) {
        this.mavenAggregateModules = mavenAggregateModules;
    }

    public boolean isDependenciesOnly() {
        return dependenciesOnly;
    }

    public void setDependenciesOnly(boolean dependenciesOnly) {
        this.dependenciesOnly = dependenciesOnly;
    }

    public boolean isNpmIgnoreNpmLsErrors() {
        return npmIgnoreNpmLsErrors;
    }

    public void setNpmIgnoreNpmLsErrors(boolean npmIgnoreNpmLsErrors) {
        this.npmIgnoreNpmLsErrors = npmIgnoreNpmLsErrors;
    }

    public boolean isPythonResolveDependencies() {
        return pythonResolveDependencies;
    }

    public void setPythonResolveDependencies(boolean pythonResolveDependencies) {
        this.pythonResolveDependencies = pythonResolveDependencies;
    }

    public String getPipPath() {
        return pipPath;
    }

    public void setPipPath(String pipPath) {
        this.pipPath = pipPath;
    }

    public String getPythonPath() {
        return pythonPath;
    }

    public void setPythonPath(String pythonPath) {
        this.pythonPath = pythonPath;
    }

    public boolean isPythonIsWssPluginInstalled() {
        return pythonIsWssPluginInstalled;
    }

    public void setPythonIsWssPluginInstalled(boolean pythonIsWssPluginInstalled) {
        this.pythonIsWssPluginInstalled = pythonIsWssPluginInstalled;
    }

    public boolean isPythonUninstallWssPlugin() {
        return pythonUninstallWssPlugin;
    }

    public void setPythonUninstallWssPlugin(boolean pythonUninstallWssPlugin) {
        this.pythonUninstallWssPlugin = pythonUninstallWssPlugin;
    }
}
