const yargs = require('yargs')
const {hideBin} = require('yargs/helpers')
const requiredArgs = ['sourceFile','configPath','transpiledPath','mappingPath'];
const fs = require('fs');
const babel = require("@babel/core");

const argv = yargs(hideBin(process.argv)).demandOption(requiredArgs).argv
var config =""
console.log(argv.configPath)

try {
  const data = fs.readFileSync(argv.configPath, 'utf8')
  config = JSON.parse(data);
} catch (err) {
  console.error(err)
}
if(config === ""){
    console.log("failed to read config file")
    process.exit(-1)
}
let args = {
    "sourceFile": argv.sourceFile,
    "config": config,
    "transpiledPath": argv.transpiledPath,
    "mappingPath": argv.mappingPath
}
let code = fs.readFileSync(args.sourceFile).toString();
let res = babel.transform(code, args.config);

fs.writeFileSync(args.mappingPath, JSON.stringify(res.map))
fs.writeFileSync(args.transpiledPath, res.code)
