package com.wss.scanner.registry.utils.filesParsers;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.wss.common.logging.LogContext;
import com.wss.common.logging.LogUtils;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.*;

public class TextFileParser {
    /* --- Private Static Fields --- */
    private final static Logger logger = LoggerFactory.getLogger(TextFileParser.class);

    /* --- Private Fields --- */

    /* --- Constructors --- */
    public TextFileParser() {}

    /**
     * In this method we parse text file line by line, by a specific delimiter
     * @param logContext - the log context
     * @param filePath   - the text file we want to parse
     * @param delimiter  - the delimiter we want to split each line with
     * @return a map containing each line as a key and value, splitted by the delimiter
     */
    public Map<String, String> parseTxtFileLineByLineWithDelimiter(LogContext logContext, String filePath,
                                                                   String delimiter) {
        Map<String, String> parsedFile = new LinkedHashMap<>();
        try {
            BufferedReader in = new BufferedReader(new FileReader(filePath));
            Scanner read = new Scanner(in);

            while(read.hasNext())
            {
                String line = read.nextLine();
                if (line.contains(delimiter)) {
                    String[] split = line.split(delimiter, 2);
                    parsedFile.put(split[0].trim(), split[1].trim());
                }
            }
            read.close();
        } catch (Exception e) {
            logger.error(LogUtils.getExceptionErrorMessage(logContext, e, this.getClass().getName() +
                    " - parseTxtFileLineByLineWithDelimiter - error while parsing the txt file "));
        }
        return parsedFile;
    }

    /**
     * In this method we parse text file line by line
     * @param logContext - the log context
     * @param filePath   - the text file we want to parse
     * @return a list holding all the parsed lines from the text file
     */
    public List<String> parseTxtFileLineByLine(LogContext logContext, String filePath) {
        logger.info(LogUtils.formatLogMessage(logContext, "parsing lines from file {}"), filePath);
        List<String> parsedFileLines = new LinkedList<>();
        try {
            BufferedReader in = new BufferedReader(new FileReader(filePath));
            Scanner read = new Scanner(in);

            while(read.hasNext())
            {
                String line = read.nextLine();
                parsedFileLines.add(line);
            }
            read.close();
        } catch (Exception e) {
            logger.error(LogUtils.getExceptionErrorMessage(logContext, e, this.getClass().getName() +
                    " - parseTxtFileLineByLine - error while parsing the txt file"));
        }
        return parsedFileLines;
    }
}
