package com.wss.scanner.registry.utils;

import java.nio.file.FileSystems;

public class Constants {
    public static final String TEMP_DIR             = System.getProperty("java.io.tmpdir");
    public static final String FileSystemSeparator  = FileSystems.getDefault().getSeparator();
    public static final String NEW_LINE             = "\n";
    public static final String TWO_STARS_SLASH      = "**\\";
    public static final String SLASH_TWO_STARS      = "\\**";
    public static final String TWO_STARS            = "**";
    public static final String STAR                 = "*";
    public static final String EQUALS               = "=";
    public static final String TWO_COLONS           = "::";
    public static final String COLON                = ":";
    public static final String AT                   = "@";
    public static final String DOLLAR               = "$";
    public static final String QUOTATION_MARK       = "\"";
    public static final String APOSTROPHE           = "'";
    public static final String DASH                 = "-";
    public static final String DOT                  = ".";
    public static final String COMMA                = ",";
    public static final String PIPE                 = "|";
    public static final String EMPTY_STRING         = "";
    public static final String SPACE                = " ";
    public static final String DASH_DASH            = "--";
    public static final String OPEN_ROUND_BRACKETS  = "(";
    public static final String CLOSE_ROUND_BRACKETS = ")";
    public static final String OPEN_CURLY_BRACKETS  = "{";
    public static final String CLOSE_CURLY_BRACKETS = "}";
    public static final String LESS_THAN            = "<";
    public static final String GREATER_THAN         = ">";
    public static final String HTTPS_PATTERN        = "https://";
    public static final String HTTP_PATTERN         = "http://";
    public static final String DOUBLE_FORWARD_SLASH = "//";
    public static final String FORWARD_SLASH        = "/";
    public static final String OP                   = "-op-";
    public static final String ORIGIN               = "_origin";
    public static final String OS_NAME              = "os.name";
    public static final String WIN                  = "win";
    public static final String TEST                 = "test";
    public static final String EXAMPLE              = "example";
    public static final String EXAMPLES             = "examples";
    public static final String URL                  = "url";
    public static final String URI                  = "uri";
    public static final String CLASS                = "class";
    public static final String CHECK                = "check";
    public static final String SYSTEM_LEVEL         = "systemLevel";
    public static final String PROJECT_LEVEL        = "projectLevel";
    public static final String ENV_VARIABLE_LEVEL   = "envVariableLevel";
    public static final String SCANNER_CUSTOM_PROP_ = "SCANNER_CUSTOM_PROP_";
    public static final String CMD                  = "cmd";
    public static final String BIN_SH               = "/bin/sh";
    public static final String C_CHAR_WINDOWS       = "/c";
    public static final String C_CHAR_LINUX         = "-c";
    public static final String MINUS_S              = "-s";
    public static final String TRUE                 = "true";
    public static final String WS_PROFILE_ID        = "ws-profile-id";
    public static final String WS_RULE_NAME         = "ws-rule-name-";
    public static final String WS_RULE_ID           = "ws-rule-id-";
    public static final String UNDEFINED            = "undefined";
    public static final String DOUBLE_UNDERSCORE = "__";
    public static final String EXTERNAL_FILE_APPENDER = "externalFileAppender";
    public static final String EXTERNAL_CONSOLE_APPENDER = "externalConsoleAppender";
    public static final String SCANNER_FILE_APPENDER = "scannerFileAppender";
    public static final String ORG_WHITESOURCE_LOGGER_NAME = "org.whitesource";
    public static final String COM_MEND_LOGGER_NAME = "com.mend";
    public static final String IO_MEND_LOGGER_NAME = "io.mend";
    public static final String LOG_ = "log_";
    public static final String WSZIP_EXTENSION = ".wszip";
    public static final String UNDERSCORE = "_";


    //NPM
    public static final String NPM                  = "npm";
    public static final String NPM_RC               = ".npmrc";
    public static final String WS_BOWER             = ".ws_bower";
    public static final String NODE_MODULES         = "node_modules";
    public static final String PACKAGE_JSON         = "package.json";
    public static final String BOWER_COMPONENTS     = "bower_components";
    public static final String AUTH_TOKEN_PATTERN   = "/:_authToken";
    public static final String NPM_PASSWORD_PATTERN = "/:_password";
    public static final String NPM_USERNAME_PATTERN = "/:username";
    public static final String REGISTRY             = "registry";

    //YARN
    public static final String YARN                 = "yarn";
    public static final String YARNRC_YML           = ".yarnrc.yml";
    public static final String NPM_REGISTRIES       = "npmRegistries";
    public static final String NPM_SCOPES           = "npmScopes";
    public static final String UNSAFE_HTTP_WHITELIST = "unsafeHttpWhitelist";
    public static final String NPM_ALWAYS_AUTH      = "npmAlwaysAuth";
    public static final String NPM_AUTH_TOKEN       = "npmAuthToken";
    public static final String NPM_AUTH_IDENT       = "npmAuthIdent";
    public static final String YARN_PATH            = "yarnPath";
    public static final String NPM_REGISTRY_SERVER  = "npmRegistryServer";

    // MAVEN
    public static final String MAVEN                = "maven";
    public static final String SETTINGS_XML         = "settings.xml";
    public static final String SERVERS              = "servers";
    public static final String SERVER               = "server";
    public static final String MIRRORS              = "mirrors";
    public static final String MIRROR               = "mirror";
    public static final String MIRROR_OF            = "mirrorOf";
    public static final String USERNAME             = "username";
    public static final String PASSWORD             = "password";
    public static final String ID                   = "id";
    public static final String REPOSITORIES         = "repositories";
    public static final String REPOSITORY           = "repository";
    public static final String PLUGIN_REPOSITORIES  = "pluginRepositories";
    public static final String PLUGIN_REPOSITORY    = "pluginRepository";
    public static final String PROFILES             = "profiles";
    public static final String PROFILE              = "profile";
    public static final String SETTINGS             = "settings";
    public static final String NAME                 = "name";
    public static final String VALUE                = "value";
    public static final String ACTIVE_PROFILES      = "activeProfiles";
    public static final String ACTIVE_PROFILE       = "activeProfile";

    // GRADLE
    public static final String GRADLE               = "gradle";
    public static final String BUILD_GRADLE         = "build.gradle";
    public static final String BUILD_GRADLE_KTS     = "build.gradle.kts";
    public static final String SETTINGS_GRADLE      = "settings.gradle";
    public static final String SETTINGS_GRADLE_KTS  = "settings.gradle.kts";
    public static final String GRADLE_PROPERTIES    = "gradle.properties";
    public final static String IVY                  = "ivy";
    public final static String CREDENTIALS          = "credentials";
    public final static String AUTHENTICATION       = "authentication";
    public final static String ALL_PROJECTS         = "allprojects";
    public final static String BUILD_SCRIPT         = "buildscript";
    public final static String PLUGIN_MANAGEMENT    = "pluginManagement";
    public final static String DEPENDENCY_RESOLUTION_MANAGEMENT = "dependencyResolutionManagement";

    //PYTHON
    public static final String PYTHON               = "python";
    public static final String PYPI                 = "pypi";
    public static final String PIP_EXTRA_INDEX_URL  = "PIP_EXTRA_INDEX_URL";
    public static final String PIP_TRUSTED_HOST     = "PIP_TRUSTED_HOST";
    public static final String SIMPLE               = "simple";
    public static final String REQUIREMENTS_TXT     = "requirements.txt";
    public static String PIPFILE                    = "Pipfile";
    public static String PIPENV_SOURCE              = "[[source]]";
    public static String PIPENV_INDEX_NAME          = "name";
    public static String PIPENV_ENABLE_SSL          = "verify_ssl = true";
    public static String PIPENV_ENV_USER_NAME       = "userName";
    public static String PIPENV_ENV_PASSWARD        = "password";
    public static String PIPENV_ENV_TOKEN           = "token";
    public static final String TOKEN           = "token";
    public static String PIPENV_ENV_FILE_NAME       = ".env";


    //RUBY
    public static final String RUBY                 = "ruby";
    public static final String BUNDLE_PREFIX        = "BUNDLE_";

    //GO
    public static final String GO                   = "go";
    public static final String ENV                  = "env";
    public static final String LIST                 = "list";
    public static final String DEPS                 = "-deps";
    public static final String GOPROXY              = "GOPROXY";
    public static final String GONOSUMDB            = "GONOSUMDB";

    //NUGET
    public static final String NUGET                = "nuget";
    public static final String NUGET_CONFIG_LOWER = "nuget.config";
    public static final String NUGET_CONFIG_UPPER = "NuGet.Config";
    public static final String DOT_SLN = ".sln";
    public static final String DOT_CSPROJ           = ".csproj";
    public static final String DOT_NUSPEC           = ".nuspec";
    public static final String PACKAGES_CONFIG      = "packages.config";
    public static final String ADD                  = "add";
    public static final String KEY                  = "key";
    public static final String CONFIGURATION        = "configuration";
    public static final String PACKAGE_SOURCES      = "packageSources";
    public static final String API_KEYS             = "apikeys";
    public static final String PACKAGE_SOURCE_CREDENTIALS = "packageSourceCredentials";
    public static final String SBT = "sbt";
    public static final  String  CREDENTIALS_FILE= "credentials.sbt";
    public static final  String SBT_FILE = "build.sbt";
    public static final  String RESOLVERS = "resolvers";
    public static final  String SBT_REALM = "realm";
    public static final String AUTHENTICATEHEADERS = "WWW-Authenticate";
    public static final String GET =  "GET";

    public static final String USER_DIR =  "user.dir";

    public static final String GRADEL_USER_HOME =  "gradle.user.home";


}
