package com.wss.github.scanner.api.dto;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

/**
 * Object for representing a GitHub repository.
 *
 * @author tom.shapira
 */
public class GitHubRepository implements Serializable {

    /* --- Static members --- */

    private static final long serialVersionUID = 7720141288900921111L;

    /* --- Members --- */

    private String gitUrl;
    private String name;
    private String branch;
    private String projectToken;
    private Set<String> languages;

    /* --- Constructors --- */

    public GitHubRepository() {
        languages = new HashSet<String>();
    }

    /* --- Getters / Setters --- */

    public String getGitUrl() {
        return gitUrl;
    }

    public void setGitUrl(String gitUrl) {
        this.gitUrl = gitUrl;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBranch() {
        return branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public String getProjectToken() {
        return projectToken;
    }

    public void setProjectToken(String projectToken) {
        this.projectToken = projectToken;
    }

    public Set<String> getLanguages() {
        return languages;
    }

    public void setLanguages(Set<String> languages) {
        this.languages = languages;
    }
}
