"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _helperPluginUtils = require("@babel/helper-plugin-utils");

var _default = (0, _helperPluginUtils.declare) ( api => {
  return {

    visitor: {

      ClassDeclaration(path) {

        //Delete all decorators of this class
        path.node.decorators = null;

        //Delete all decorators in the class
        if (path.node.body && path.node.body.body){
          for(const node of path.node.body.body) {
            node.decorators = null;
            if (node.params){
              node.params.forEach( param => param.decorators = null )
            }
          }
        }
      }
    }
  };
});

exports.default = _default;
