package com.wss.scanner.registry.models;

import java.util.Map;
import java.util.Objects;

public class HostRule {

    /* --- Private members --- */

    String matchHost;
    String hostType;
    String hostRegistryType;
    String userName;
    String password;
    String token;
    String sourceName;
    Map<String, String> envVariablesMapping;
    private Map<String, String> secrets;

    /* --- Constructor --- */

    public HostRule() {
    }

    public HostRule(HostRule another) {
        setUserName(another.getUserName());
        setToken(another.getToken());
        setPassword(another.getPassword());
        setMatchHost(another.getMatchHost());
        setHostType(another.getHostType());
        setHostRegistryType(another.getHostRegistryType());
        setSourceName(another.getSourceName());
        setEnvVariablesMapping(another.getEnvVariablesMapping());
    }

    /* --- Getters / Setters --- */

    public String getMatchHost() {
        return matchHost;
    }

    public void setMatchHost(String matchHost) {
        this.matchHost = matchHost;
    }

    public String getHostType() {
        return hostType;
    }

    public void setHostType(String hostType) {
        this.hostType = hostType;
    }

    public String getHostRegistryType() {
        return hostRegistryType;
    }

    public void setHostRegistryType(String hostRegistryType) {
        this.hostRegistryType = hostRegistryType;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getSourceName() {
        return sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public Map<String, String> getEnvVariablesMapping() {
        return envVariablesMapping;
    }

    public void setEnvVariablesMapping(Map<String, String> envVariablesMapping) {
        this.envVariablesMapping = envVariablesMapping;
    }

    public Map<String, String> getSecrets() {
        return secrets;
    }

    public void setSecrets(Map<String, String> secrets) {
        this.secrets = secrets;
    }

}
