package com.wss.github.scanner.api.dto;

import java.io.Serializable;
import java.util.*;

public class SourceControlScanRequestDTO implements Serializable {

    /* --- Static members --- */

    private static final long serialVersionUID = -3364133086257109916L;

    /* --- Members --- */

    private Integer id;
    private String requestOrigin;
    private String type;
    private String domainName;
    private Integer domainId;
    private Integer userId;
    private String userName;
    private String cloneUrl;
    private Date creationTime;
    private Integer priority;
    private String gitHookType;
    private String hookName;
    private String githubUser;
    private String repository;
    private String scanState;
    private String accessToken;
    private String projectToken;
    private String orgToken;
    private SourceControlScanParams sourceControlScanParams;
    private List<DownloadLinkAndFileNameDTO> downloadLinks;
    private String packageType;
    private String logContext;
    private Integer dequeueCount;
    private byte[] scanParams;


    /* --- Constructors --- */

    public SourceControlScanRequestDTO(Integer id, String domainName, Integer domainId, Integer userId, String userName, String cloneUrl, Date creationTime, Integer priority, String gitHookType, String hookName, String githubUser, String repository, String scanState, String accessToken, String projectToken, String orgToken, byte[] scanParams) {
        this.id = id;
        this.type = type;
        this.domainName = domainName;
        this.domainId = domainId;
        this.userId = userId;
        this.userName = userName;
        this.cloneUrl = cloneUrl;
        this.creationTime = creationTime;
        this.priority = priority;
        this.gitHookType = gitHookType;
        this.hookName = hookName;
        this.githubUser = githubUser;
        this.repository = repository;
        this.scanState = scanState;
        this.accessToken = accessToken;
        this.projectToken = projectToken;
        this.orgToken = orgToken;
        this.requestOrigin = requestOrigin;
        this.sourceControlScanParams = sourceControlScanParams;
        this.scanParams = scanParams;
    }

    public SourceControlScanRequestDTO() {
        downloadLinks = new ArrayList<>();
    }

    /* --- Overridden methods --- */

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof SourceControlScanRequestDTO)) return false;
        SourceControlScanRequestDTO that = (SourceControlScanRequestDTO) o;
        return Objects.equals(id, that.id) &&
                Objects.equals(domainName, that.domainName) &&
                Objects.equals(domainId, that.domainId) &&
                Objects.equals(userId, that.userId) &&
                Objects.equals(userName, that.userName) &&
                Objects.equals(cloneUrl, that.cloneUrl) &&
                Objects.equals(creationTime, that.creationTime) &&
                Objects.equals(priority, that.priority) &&
                Objects.equals(gitHookType, that.gitHookType) &&
                Objects.equals(hookName, that.hookName) &&
                Objects.equals(githubUser, that.githubUser) &&
                Objects.equals(repository, that.repository) &&
                Objects.equals(scanState, that.scanState) &&
                Objects.equals(accessToken, that.accessToken) &&
                Objects.equals(projectToken, that.projectToken) &&
                Objects.equals(orgToken, that.orgToken) &&
                Arrays.equals(scanParams, that.scanParams);
    }

    @Override
    public int hashCode() {

        int result = Objects.hash(id, domainName, domainId, userId, userName, cloneUrl, creationTime, priority, gitHookType, hookName, githubUser, repository, scanState, accessToken, projectToken, orgToken);
        result = 31 * result + Arrays.hashCode(scanParams);
        return result;
    }

    /* --- Getters / Setters --- */

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getDomainName() {
        return domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public Integer getDomainId() {
        return domainId;
    }

    public void setDomainId(Integer domainId) {
        this.domainId = domainId;
    }

    public Integer getUserId() {
        return userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getCloneUrl() {
        return cloneUrl;
    }

    public void setCloneUrl(String cloneUrl) {
        this.cloneUrl = cloneUrl;
    }

    public Date getCreationTime() {
        return creationTime;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Integer getPriority() {
        return priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String getGitHookType() {
        return gitHookType;
    }

    public void setGitHookType(String gitHookType) {
        this.gitHookType = gitHookType;
    }

    public String getHookName() {
        return hookName;
    }

    public void setHookName(String hookName) {
        this.hookName = hookName;
    }

    public String getGithubUser() {
        return githubUser;
    }

    public void setGithubUser(String githubUser) {
        this.githubUser = githubUser;
    }

    public String getRepository() {
        return repository;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public String getScanState() {
        return scanState;
    }

    public void setScanState(String scanState) {
        this.scanState = scanState;
    }

    public String getAccessToken() {
        return accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getProjectToken() {
        return projectToken;
    }

    public void setProjectToken(String projectToken) {
        this.projectToken = projectToken;
    }

    public String getOrgToken() {
        return orgToken;
    }

    public void setOrgToken(String orgToken) {
        this.orgToken = orgToken;
    }

    public byte[] getScanParams() { return scanParams; }

    public void setSourceControlScanParams(SourceControlScanParams sourceControlScanParams) {
        this.sourceControlScanParams = sourceControlScanParams;
    }

    public String getRequestOrigin() {
        return requestOrigin;
    }

    public void setRequestOrigin(String requestOrigin) {
        this.requestOrigin = requestOrigin;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<DownloadLinkAndFileNameDTO> getDownloadLinks() {
        return downloadLinks;
    }

    public void setDownloadLinks(List<DownloadLinkAndFileNameDTO> scanSettings) {
        this.downloadLinks = scanSettings;
    }

    public String getPackageType() {
        return packageType;
    }

    public void setPackageType(String packageType) {
        this.packageType = packageType;
    }

    public String getLogContext() {
        return logContext;
    }

    public void setLogContext(String logContext) {
        this.logContext = logContext;
    }

    public Integer getDequeueCount() {
        return dequeueCount;
    }

    public void setDequeueCount(Integer dequeueCount) {
        this.dequeueCount = dequeueCount;
    }

    public void setScanParams(byte[] scanParams) { this.scanParams = scanParams; }
}
