package com.wss.common.results.scaResultsDTO;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Arye.Hochman
 */
@Getter
@Setter
@JsonIgnoreProperties(ignoreUnknown = true)
public class ScaResultsDTO {

    @JsonProperty("results")
    private Map<String, List<ScaResObjDTO>> results;

    @JsonProperty("tags")
    private Map<String, List<String>> tags;

    @JsonProperty("totalSuccess")
    private Map<String, Integer> totalSuccess;

    @JsonProperty("totalFail")
    private Map<String, Integer> totalFail;

    public ScaResultsDTO() {
        results = new HashMap<>();
        tags = new HashMap<>();
        totalSuccess = new HashMap<>();
        totalFail = new HashMap<>();
    }
}
