package com.wss.common.results.repoResultsDTO;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Arye.Hochman
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class RepoResultsDTO {

    @JsonProperty("results")
    private Map<String, List<Map<String, Map<String, List<RepoResObjDTO>>>>> results;

    @JsonProperty("totalSuccess")
    private Map<String, Integer> totalSuccess;

    @JsonProperty("totalFail")
    private Map<String, Integer> totalFail;

    @JsonProperty("limited")
    private int limited;

    public RepoResultsDTO() {
        results = new HashMap<>();
        totalSuccess = new HashMap<>();
        totalFail = new HashMap<>();
    }

    public RepoResultsDTO(Map<String, Integer> totalSuccess, Map<String, Integer> totalFail) {
        results = new HashMap<>();
        this.totalSuccess = totalSuccess;
        this.totalFail = totalFail;
    }
}
