/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;

/* Create table in target */
CREATE TABLE `bolt_gitHubAppInstallationProperties`(
	`id` int(11) NOT NULL  auto_increment ,
	`createdDate` datetime NULL  ,
	`activationTime` datetime NULL  ,
	`additionalProperties` longtext COLLATE utf8_general_ci NULL  ,
	`country` varchar(255) COLLATE utf8_general_ci NULL  ,
	`ghInstallationId` varchar(255) COLLATE utf8_general_ci NULL  ,
	`gitHubAppId` varchar(255) COLLATE utf8_general_ci NULL  ,
	`gitHubPrivateKeyId` int(11) NULL  ,
	`installationUserEmail` varchar(255) COLLATE utf8_general_ci NULL  ,
	`lastAccessDate` datetime NULL  ,
	`licenseKeyCreationTime` datetime NULL  ,
	`registrationStatus` varchar(255) COLLATE utf8_general_ci NULL  ,
	`registrationType` varchar(255) COLLATE utf8_general_ci NULL  ,
	`registrationUserEmail` varchar(255) COLLATE utf8_general_ci NULL  ,
	`secretName` varchar(255) COLLATE utf8_general_ci NULL  ,
	`verificationToken` varchar(255) COLLATE utf8_general_ci NULL  ,
	`wsEnvPropertiesId` int(11) NULL  ,
	`wsGitHubAppId` varchar(255) COLLATE utf8_general_ci NULL  ,
	`wsOrgToken` varchar(255) COLLATE utf8_general_ci NULL  ,
	PRIMARY KEY (`id`) ,
	KEY `FKna8xulji2t5geow5vsh1w9hdm`(`gitHubPrivateKeyId`) ,
	KEY `FKhfcis671m266s78q07yx2hlgd`(`wsEnvPropertiesId`) ,
	CONSTRAINT `FKhfcis671m266s78q07yx2hlgd`
	FOREIGN KEY (`wsEnvPropertiesId`) REFERENCES `bolt_wssEnvProperties` (`id`) ,
	CONSTRAINT `FKna8xulji2t5geow5vsh1w9hdm`
	FOREIGN KEY (`gitHubPrivateKeyId`) REFERENCES `bolt_gitHubAppPrivateKey` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET='utf8' COLLATE='utf8_general_ci';


/* Create table in target */
CREATE TABLE `bolt_gitHubAppPrivateKey`(
	`id` int(11) NOT NULL  auto_increment ,
	`createdDate` datetime NULL  ,
	`gitHubAppId` varchar(255) COLLATE utf8_general_ci NULL  ,
	`secretName` varchar(255) COLLATE utf8_general_ci NULL  ,
	`wsGitHubAppId` varchar(255) COLLATE utf8_general_ci NULL  ,
	PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET='utf8' COLLATE='utf8_general_ci';


/* Create table in target */
CREATE TABLE `bolt_gitHubPayload`(
	`id` int(11) NOT NULL  auto_increment ,
	`createdDate` datetime NULL  ,
	`ghAppInstPropertiesId` int(11) NULL  ,
	`ghInstallationPayload` longtext COLLATE utf8_general_ci NULL  ,
	PRIMARY KEY (`id`) ,
	KEY `FKoysbjpghl5n3e1h65f999235r`(`ghAppInstPropertiesId`) ,
	CONSTRAINT `FKoysbjpghl5n3e1h65f999235r`
	FOREIGN KEY (`ghAppInstPropertiesId`) REFERENCES `bolt_gitHubAppInstallationProperties` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET='utf8' COLLATE='utf8_general_ci';


/* Create table in target */
CREATE TABLE `bolt_ruleContext`(
	`id` int(11) NOT NULL  auto_increment ,
	`createdDate` datetime NULL  ,
	`ghAppInstPropertiesId` int(11) NULL  ,
	`ghInstallationId` varchar(255) COLLATE utf8_general_ci NULL  ,
	`lastUpdate` datetime NULL  ,
	`ruleData` longtext COLLATE utf8_general_ci NULL  ,
	`type` varchar(255) COLLATE utf8_general_ci NULL  ,
	PRIMARY KEY (`id`) ,
	KEY `FKo51npc4uplt7egh0ttlx2j9db`(`ghAppInstPropertiesId`) ,
	CONSTRAINT `FKo51npc4uplt7egh0ttlx2j9db`
	FOREIGN KEY (`ghAppInstPropertiesId`) REFERENCES `bolt_gitHubAppInstallationProperties` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET='utf8' COLLATE='utf8_general_ci';


/* Create table in target */
CREATE TABLE `bolt_wssEnvProperties`(
	`id` int(11) NOT NULL  auto_increment ,
	`createdDate` datetime NULL  ,
	`environmentId` varchar(255) COLLATE utf8_general_ci NULL  ,
	`environmentUrl` varchar(255) COLLATE utf8_general_ci NULL  ,
	`wssAccessToken` varchar(255) COLLATE utf8_general_ci NULL  ,
	PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET='utf8' COLLATE='utf8_general_ci';

/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;