/*
 * Decompiled with CFR 0.152.
 */
package com.wss.container;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.wss.container.configModel.FilesModel;
import com.wss.container.configModel.ModelConfiguration;
import com.wss.container.configModel.PropertiesModel;
import com.wss.container.configModel.PropertyOption;
import com.wss.container.configModel.TypeConfigOption;
import com.wss.container.utils.PropertyUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.text.StringSubstitutor;

public class PropertiesParser {
    private static final String PROP_JSON = "prop.json";
    private List<PropertiesModel> propertiesModel;
    private List<FilesModel> filesModels;

    public PropertiesParser(List<String> propertyJsonPaths) {
        this.propertiesModel = new ArrayList<PropertiesModel>();
        this.filesModels = new ArrayList<FilesModel>();
        for (String currentPropertyJsonPath : propertyJsonPaths) {
            try {
                if (this.getClass().getClassLoader().getResource(currentPropertyJsonPath) != null && new File(this.getClass().getClassLoader().getResource(currentPropertyJsonPath).toURI()).exists()) {
                    JsonReader jsonReader = new JsonReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(currentPropertyJsonPath)));
                    ModelConfiguration modelConfiguration = (ModelConfiguration)new Gson().fromJson(jsonReader, (Type)((Object)ModelConfiguration.class));
                    this.propertiesModel = PropertyUtils.mergeLists(this.propertiesModel, modelConfiguration.getPropertiesModel());
                    this.filesModels = PropertyUtils.mergeLists(this.filesModels, modelConfiguration.getFilesModel());
                    continue;
                }
                System.err.println("PropertiesParser, The file " + currentPropertyJsonPath + " does not exist");
            }
            catch (Exception e) {
                System.err.println("PropertiesParser, Exception parsing the file " + currentPropertyJsonPath + ", message: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public PropertiesParser(String propertyJsonPath) {
        try {
            JsonReader jsonReader = new JsonReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(propertyJsonPath)));
            ModelConfiguration modelConfiguration = (ModelConfiguration)new Gson().fromJson(jsonReader, (Type)((Object)ModelConfiguration.class));
            this.propertiesModel = modelConfiguration.getPropertiesModel();
            this.filesModels = modelConfiguration.getFilesModel();
        }
        catch (Exception e) {
            System.err.println("PropertiesParser, The file " + propertyJsonPath + " wasn't found, cause: " + e.getMessage());
        }
    }

    public void injectProperties(boolean preconfigurePropertiesOnly) {
        for (PropertiesModel propertiesModel : this.propertiesModel) {
            if (preconfigurePropertiesOnly && !propertiesModel.getPropertyName().startsWith("preconfig_")) continue;
            if (propertiesModel.getTypeConfig() != null) {
                for (TypeConfigOption typeConfigOption : propertiesModel.getTypeConfig().getTypeConfigOptions()) {
                    if (!typeConfigOption.getValue().equals(propertiesModel.getPropertyValue())) continue;
                    if (typeConfigOption.getMultipleProperties() != null && typeConfigOption.getMultipleProperties().size() > 0) {
                        for (PropertyOption propertyOption : typeConfigOption.getMultipleProperties()) {
                            this.injectPropertiesToPaths(propertyOption);
                        }
                        continue;
                    }
                    this.injectPropertiesToPaths(propertiesModel);
                }
                continue;
            }
            this.injectPropertiesToPaths(propertiesModel);
        }
    }

    public void copyFiles() {
        Map<String, String> propertiesMap = this.toPropertiesMap();
        StringSubstitutor stringSubstitutor = new StringSubstitutor(propertiesMap);
        for (FilesModel filesModel : this.filesModels) {
            String destination = stringSubstitutor.replace(filesModel.getDestination());
            String source = stringSubstitutor.replace(filesModel.getSource());
            File destFile = new File(destination);
            try {
                FileUtils.copyFile(new File(source), destFile);
            }
            catch (IOException e) {
                System.out.println("Could not copy source file to destination file");
            }
            if (!filesModel.getFilename().contains(PROP_JSON)) continue;
            ModelConfiguration modelConfiguration = new ModelConfiguration(this.propertiesModel, this.filesModels);
            try {
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                FileWriter writer = new FileWriter(filesModel.getDestination());
                gson.toJson((Object)modelConfiguration, (Appendable)writer);
                writer.flush();
                writer.close();
            }
            catch (Exception e) {
                System.out.println("Failed to write to file");
            }
        }
    }

    protected boolean writeParameterValue(PropertyOption propertyOption, String propertyPath, int lineNumber) {
        boolean retValue = false;
        String propertyName = propertyOption.getPropertyName();
        boolean noValueSanitization = false;
        if (propertyOption instanceof PropertiesModel) {
            noValueSanitization = ((PropertiesModel)propertyOption).isNoValueSanitization();
        }
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        propertyMap.put(propertyName, PropertyUtils.getSanitizedValue(propertyOption.getPropertyValue(), noValueSanitization));
        StringSubstitutor stringSubstitutor = new StringSubstitutor(propertyMap);
        Path path = Paths.get(propertyPath, new String[0]);
        try {
            List<String> lines = Files.readAllLines(path, StandardCharsets.UTF_8);
            for (int i = 0; i < lines.size(); ++i) {
                String currentLine = lines.get(i);
                String updatedLine = stringSubstitutor.replace(currentLine);
                lines.set(i, updatedLine);
                if (currentLine == null || currentLine.equals(updatedLine)) continue;
                retValue = true;
            }
            Files.write(path, lines, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (Exception e) {
            System.err.println("PropertiesParser, Couldn't update file " + propertyPath + ", cause: " + e.getMessage());
        }
        return retValue;
    }

    protected void injectPropertiesToPaths(PropertyOption propertyOption) {
        String propertyName = propertyOption.getPropertyName();
        Collection<String> paths = propertyOption.getPropertyPaths();
        for (String path : paths) {
            File file = new File(path);
            if (file.exists()) {
                int count = 0;
                try {
                    if (!this.writeParameterValue(propertyOption, path, count)) continue;
                    System.out.println("Updated file " + path + " with property " + propertyName);
                }
                catch (Exception e) {
                    System.err.println("PropertiesParser, Property " + propertyName + ", couldn't find " + file.getPath() + ", cause: " + e.getMessage());
                }
                continue;
            }
            System.err.println("PropertiesParser, Property " + propertyName + ", couldn't find " + file.getPath());
        }
    }

    public List<PropertiesModel> getPropertiesModel() {
        return this.propertiesModel;
    }

    public static PropertyOption getPropertyModel(List<PropertiesModel> propertiesModel, String propertyName) {
        if (propertyName != null) {
            for (PropertiesModel currentPropertiesModel : propertiesModel) {
                if (!propertyName.equals(currentPropertiesModel.getPropertyName())) continue;
                return currentPropertiesModel;
            }
        }
        return null;
    }

    public Map<String, String> toPropertiesMap() {
        return PropertiesParser.toPropertiesMap(this.propertiesModel);
    }

    public static Map<String, String> toPropertiesMap(List<PropertiesModel> propertiesModel) {
        HashMap<String, String> retValue = new HashMap<String, String>();
        for (PropertiesModel currentPropertyModel : propertiesModel) {
            try {
                retValue.put(currentPropertyModel.getPropertyName(), PropertyUtils.getSanitizedValue(currentPropertyModel.getPropertyValue(), currentPropertyModel.isNoValueSanitization()));
            }
            catch (Exception e) {
                System.err.println("PropertiesParser, Exception creating propertyMap, " + e.getMessage());
                e.printStackTrace();
            }
        }
        return retValue;
    }
}

