from __future__ import print_function

import json
import os
import sys

from sources.representation.common import to_canonical


def get_parent_dir(filepath):
    return os.path.dirname(filepath)


class ModulePathsMapper:
    def __init__(self, imports_file):
        self.imports_file = imports_file
        self.parsed = {}
        self._parse_imports_file_()

    def to_filepath(self, importing_file, imported_name, relative_level):
        canonical_importing_file = to_canonical(importing_file)
        imported_name = '.' * relative_level + ("" if imported_name is None else imported_name)
        if self.contains_mapping(canonical_importing_file, imported_name):
            return self.parsed[canonical_importing_file][imported_name]
        else:
            print("Couldn't map import (%s) to file (%s)" % (imported_name, canonical_importing_file), file=sys.stderr)
            return ""

    def contains_mapping(self, importing_file, imported_name):
        return importing_file in self.parsed and imported_name in self.parsed[importing_file]

    def _parse_imports_file_(self):
        with open(self.imports_file) as imports_file:
            data = json.load(imports_file)
        for file_and_import, imported_path in data.items():
            last_colon_idx = file_and_import.rfind(':')
            file = to_canonical(file_and_import[:last_colon_idx])
            _import = file_and_import[last_colon_idx + 1:]
            canonical_imported_path = to_canonical(imported_path)
            if file not in self.parsed:
                self.parsed[file] = {}
            self.parsed[file][_import] = canonical_imported_path
