package com.wss.scanner.registry.utils.filesParsers;

import com.wss.common.logging.LogContext;
import com.wss.common.logging.LogUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class YamlParser {
    /* --- Private Static Fields --- */
    private final static Logger logger = LoggerFactory.getLogger(YamlParser.class);

    /* --- Private Fields --- */

    /* --- Constructors --- */
    public YamlParser() {
    }

    /* --- Public Methods --- */

    /**
     * This method parsed yaml file content
     * @param logContext - the log context
     * @param filePath   - the yaml file to parse
     * @return the yaml file content as a map of keys and objects
     */
    public Map<String, Object> parseYamlFile(LogContext logContext, String filePath) {
        Yaml yaml = new Yaml();
        try {
            InputStream inputStream = new FileInputStream(filePath);
            Map<String, Object> yamlObj = yaml.load(inputStream);
            inputStream.close();
            return yamlObj;
        } catch (Exception e) {
            logger.error(LogUtils.getExceptionErrorMessage(logContext, e, this.getClass().getName() +
                    " - parseYamlFile - error while parsing the yaml file at {} "), filePath);
        }
        return new HashMap<>();
    }

    /**
     * This method parsed the yaml content from a string
     * @param logContext  - the log context
     * @param yamlContent - the yaml content as a string
     * @return the yaml string content as a map of keys and objects
     */
    public Map<String, Object> parseYamlFromString(LogContext logContext, String yamlContent) {
        Yaml yaml = new Yaml();
        try {
            return yaml.load(yamlContent);
        } catch (Exception e) {
            logger.error(LogUtils.getExceptionErrorMessage(logContext, e, this.getClass().getName() +
                    " - parseYamlFromString - error while parsing the yaml content from string "));
        }
        return new HashMap<>();
    }
}
