package com.wss.github.scanner.api.dto;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

/**
 * Request for initializing a GitHub repository scan.
 *
 * @author tom.shapira
 */
public class ScanGitHubRepositoriesRequest implements Serializable {

    /* --- Static members --- */

    private static final long serialVersionUID = -4969891672990349913L;

    /* --- Members --- */

    private String orgToken;
    private String productToken;
    private String accessToken;
    private String instanceId;
    private String serviceUrl;
    private Collection<GitHubRepository> gitHubRepositories;

    /* --- Constructors --- */

    public ScanGitHubRepositoriesRequest() {
        gitHubRepositories = new ArrayList<GitHubRepository>();
    }

    /* --- Getters / Setters --- */

    public String getOrgToken() {
        return orgToken;
    }

    public void setOrgToken(String orgToken) {
        this.orgToken = orgToken;
    }

    public String getProductToken() {
        return productToken;
    }

    public void setProductToken(String productToken) {
        this.productToken = productToken;
    }

    public String getAccessToken() {
        return accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getServiceUrl() {
        return serviceUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public Collection<GitHubRepository> getGitHubRepositories() {
        return gitHubRepositories;
    }

    public void setGitHubRepositories(Collection<GitHubRepository> gitHubRepositories) {
        this.gitHubRepositories = gitHubRepositories;
    }
}
