package com.wss.scanner.registry.utils.filesParsers;

import com.wss.common.logging.LogContext;
import com.wss.common.logging.LogUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GradleFilesParser {
    private final static Logger logger = LoggerFactory.getLogger(GradleFilesParser.class);

    /**
     * In this method we parse groovy files line by line and return the file as a list of string
     * @param logContext - the log context
     * @param filePath   - the file path of the groovy file
     * @return list of strings of the parsed lines in the groovy file
     */
    public List<String> parseGroovyFile(LogContext logContext, String filePath) {
        List<String> lines = new LinkedList<>();
        try {
            try (Stream<String> result = Files.lines(Paths.get(filePath))) {
                lines = result.map(String::trim).collect(Collectors.toList());
            }
        } catch (Exception e) {
            logger.error(LogUtils.getExceptionErrorMessage(logContext, e, this.getClass().getName() +
                    " - parseGroovyFile - error while parsing groovy file"));
        }
        return lines;
    }
}
