const path = require('path');
const fs = require('fs');
const babel = require("@babel/core");
const sourceMap = require('source-map');

let file = path.resolve(__dirname, process.argv[2]);
let code = fs.readFileSync(file).toString();

function transpileCode(code) {
    return babel.transformSync(code, {
        plugins: [[require.resolve("./viaPlugin")], [require.resolve("@babel/plugin-transform-classes"), {
            "loose": true
        }]],
        presets: [require.resolve("@babel/preset-env")],
        sourceMaps: true,
        inputSourceMap: false,
        comments: false,
	    retainLines: true,
        sourceFileName: file,
        ast: false,
        sourceType: "unambiguous"
    });
}

async function getMappings(map) {
    return await sourceMap.SourceMapConsumer.with(map, null, async function (consumer) {
        const collectedMappings = [];
        consumer.eachMapping(mapping => {
            collectedMappings.push(mapping);
        });
        return collectedMappings;
    });
}

let transpiledCode = transpileCode(code);
let maps = getMappings(transpiledCode.map);

new_file = file.substr(0, file.lastIndexOf(".")) + "_transpiled.js";

fs.writeFileSync(new_file, transpiledCode.code);
new_map_file = file.substr(0, file.lastIndexOf(".")) + "_transpiled.map";

maps.then(mappings => fs.writeFileSync(new_map_file, JSON.stringify(mappings)));