package com.wss.scanner.registry.utils.registryHandlers.sbt;

import com.wss.common.logging.LogContext;
import com.wss.common.logging.LogUtils;
import com.wss.scanner.registry.models.HostRule;
import com.wss.scanner.registry.utils.registryHandlers.PrivateRegistryFileHandler;
import com.wss.scanner.registry.utils.registryHandlers.gradle.GradlePrivateRegistryHandler;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.*;

import static com.wss.scanner.registry.utils.Constants.*;
import static com.wss.scanner.registry.utils.Constants.SETTINGS_GRADLE_KTS;

public class SbtPrivateRegistryHandler  extends PrivateRegistryFileHandler {

    private final static Logger logger = LoggerFactory.getLogger(GradlePrivateRegistryHandler.class);
    @Override
    public void createRegistryObject(LogContext logContext, String registryObject, List<HostRule> hostRules){
        addCredentialsAndResolver(logContext, registryObject, hostRules, false);
    }

    @Override
    public void editRegistryObject(LogContext logContext, String registryObject, List<HostRule> hostRules){
        addCredentialsAndResolver(logContext, registryObject, hostRules, true);
    }

    @Override
    public boolean isProjectLevelRegistryFile() {
        return true;
    }

    @Override
    public boolean isSystemLevelRegistryFile() {
        return false;
    }

    @Override
    public boolean isEnvVariableRegistryCredentials() {
        return false;
    }

    @Override
    public void prepareIncludesAndExcludes(ArrayList<String> includes, ArrayList<String> excludes) {
        String[] jsIncludedManifests = new String[]{
                CREDENTIALS_FILE,
                SBT_FILE

        };
        includes.addAll(Arrays.asList(jsIncludedManifests));
    }

    @Override
    public List<String> getManifestTypes(String[] localManifestsFiles) {
        return Collections.singletonList(SBT_FILE);
    }

    @Override
    public List<String> getGlobalRegistryObject(boolean isFile) {
        return null;
    }

    @Override
    public List<String> getRegistryFileType(String manifestFile) {
        return Arrays.asList(CREDENTIALS_FILE);
    }


    public String getRealmValue(LogContext logContext, String repositoryUrl){
        try {
            URL url = new URL(repositoryUrl);
            HttpURLConnection connection = (HttpURLConnection) url.openConnection();
            connection.setRequestMethod(GET);
            connection.connect();
            Map<String, List<String>> headers = connection.getHeaderFields();
            List<String> authenticateHeaders = headers.get(AUTHENTICATEHEADERS);
            if (authenticateHeaders != null && authenticateHeaders.size() > 0) {
                String header = authenticateHeaders.get(0);
                int start = header.indexOf(SBT_REALM + EQUALS);
                int end = header.indexOf(QUOTATION_MARK, start + 7);
                return header.substring(start + 7, end);
            }
        }
        catch (Exception e) {
            logger.error(LogUtils.getExceptionErrorMessage(logContext, e, this.getClass().getName() +
                            " - runConnectivityCheck - error while running connectivity check"));
        }
        return null;
    }

    public void addCredentialsAndResolver(LogContext logContext, String registryObject, List<HostRule> hostRules, boolean CredentialsFileExists){
        int resolverIndex = 1;
        File credentialsFile = new File(registryObject);
        try (FileWriter writer = new FileWriter(credentialsFile, true)){
            if (!CredentialsFileExists) {
                credentialsFile.createNewFile();
            }
            for (HostRule hostRule : hostRules) {
                String tokenOrPassword;
                if (StringUtils.isNotBlank(hostRule.getToken())) {
                    tokenOrPassword = hostRule.getToken();
                } else if (StringUtils.isNotBlank(hostRule.getPassword())) {
                    tokenOrPassword = hostRule.getPassword();
                } else {
                    tokenOrPassword = "";
                    logger.warn(LogUtils.formatLogMessage(logContext, "No password or token were provided"));
                }
                String credentialsRealm = getRealmValue(logContext, hostRule.getMatchHost());
                if (credentialsRealm != null) {
                    String resolverName = WS_RULE_NAME + resolverIndex;
                    URL url = new URL(hostRule.getMatchHost());
                    writer.append(String.format("%s += \"%s\" at \"%s\"", RESOLVERS, resolverName, hostRule.getMatchHost()));
                    writer.append(System.lineSeparator());
                    writer.append(String.format("%s += Credentials(\"%s\", \"%s\", \"%s\", \"%s\")", CREDENTIALS, credentialsRealm, url.getHost(), hostRule.getUserName(), tokenOrPassword));
                    writer.append(System.lineSeparator());
                    resolverIndex++;
                } else {
                    logger.warn(LogUtils.formatLogMessage(logContext, "No realm found for this server " + hostRule.getMatchHost()));
                }
            }
        }
        catch (IOException e) {
            logger.error(LogUtils.getExceptionErrorMessage(logContext, e, this.getClass().getName() +
            "The sbt credentials file Not created, The SCA can Not resolver private dependencies"));
            }
        }
    }
