package com.wss.scanner.registry.utils.registryHandlers.ruby;

import com.wss.common.logging.LogContext;
import com.wss.common.logging.LogUtils;
import com.wss.scanner.registry.models.HostRule;
import com.wss.scanner.registry.utils.Constants;
import com.wss.scanner.registry.utils.OsUtils;
import com.wss.scanner.registry.utils.PrivateRegistryUtils;
import com.wss.scanner.registry.utils.registryHandlers.PrivateRegistryFileHandler;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;

import static com.wss.scanner.registry.utils.Constants.*;

public class RubyPrivateRegistry extends PrivateRegistryFileHandler {

    Logger logger = LoggerFactory.getLogger(RubyPrivateRegistry.class);

    @Override
    public void createRegistryObject(LogContext logContext, String registryObject, List<HostRule> hostRules) {
        for (HostRule hostRule : hostRules) {
            String userName = hostRule.getUserName();
            String password = StringUtils.isNotBlank(hostRule.getPassword()) ? hostRule.getPassword() : hostRule.getToken();
            if (StringUtils.isEmpty(password)) {
                logger.warn(LogUtils.formatLogMessage(logContext, "No password provided"));
                return;
            }
            String hostUpperCase = getHost(logContext, hostRule);
            if (hostUpperCase == null) return;
            System.setProperty(SCANNER_CUSTOM_PROP_ + hostUpperCase, userName.concat(":").concat(password));
        }
    }


    @Override
    public void editRegistryObject(LogContext logContext, String registryObject, List<HostRule> hostRules) {
        createRegistryObject(logContext, registryObject, hostRules);
    }

    @Override
    public boolean isProjectLevelRegistryFile() {
        return false;
    }

    @Override
    public boolean isSystemLevelRegistryFile() {
        return false;
    }

    @Override
    public boolean isEnvVariableRegistryCredentials() {
        return true;
    }

    @Override
    public void prepareIncludesAndExcludes(ArrayList<String> includes, ArrayList<String> excludes) {

    }

    @Override
    public List<String> getManifestTypes(String[] localManifestsFiles) {
        return null;
    }

    @Override
    public List<String> getGlobalRegistryObject(boolean isFile) {
        //HARDCODED since the env variable is not fixed
        return Arrays.asList(Constants.BUNDLE_PREFIX);
    }

    @Override
    public List<String> getRegistryFileType(String manifestFile) {
        return null;
    }


    private String getHost(LogContext logContext, HostRule hostRule) {
        String host = PrivateRegistryUtils.getHostName(hostRule.getMatchHost());
        if (StringUtils.isEmpty(host)) {
            logger.warn(LogUtils.formatLogMessage(logContext, "URL is malformed"));
            return null;
        }

        host = host.replace(Constants.DOT, Constants.DOUBLE_UNDERSCORE);
        //in case port is included
        host = StringUtils.substringBefore(host, COLON).toUpperCase(Locale.ROOT);
        return BUNDLE_PREFIX.concat(host);
    }

}
