/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;

/* Create table in target */
CREATE TABLE `bolt_azdoIntegrationProperties`(
	`id` int(11) NOT NULL  auto_increment,
	`createdDate` datetime DEFAULT CURRENT_TIMESTAMP,
    `modifiedDate` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `removedDate` datetime NULL,
    `azdoUserId` varchar(255) COLLATE utf8_general_ci NOT NULL,
	`wsEnvPropertiesId` int(11) NOT NULL,
    `wsOrgToken` varchar(255) COLLATE utf8_general_ci NOT NULL,
    `wsServiceUserKey` varchar(255) COLLATE utf8_general_ci NOT NULL,
    `wsServiceUserEmail` varchar(255) COLLATE utf8_general_ci NOT NULL,
    `wsShadowOrgToken` varchar(255) COLLATE utf8_general_ci NOT NULL,
    `wsShadowServiceUserKey` varchar(255) COLLATE utf8_general_ci NOT NULL,
	PRIMARY KEY (`id`),
    KEY `K_azdoUserId`(`azdoUserId`, `removedDate`),
    KEY `K_wsOrgToken`(`wsOrgToken`, `removedDate`),
	KEY `FK_wsEnvId`(`wsEnvPropertiesId`),
	CONSTRAINT `FK_wsEnvId`
	FOREIGN KEY (`wsEnvPropertiesId`) REFERENCES `bolt_wssEnvProperties` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET='utf8' COLLATE='utf8_general_ci';

CREATE TABLE `bolt_azdoIntegrationCollections`(
    `id` int(11) NOT NULL  auto_increment,
    `createdDate` datetime DEFAULT CURRENT_TIMESTAMP,
    `removedDate` datetime NULL,
    `azdoIntegrationId` int(11) NOT NULL,
    `azdoCollectionId` varchar(255) COLLATE utf8_general_ci NOT NULL,
    `azdoCollectionName` varchar(255) COLLATE utf8_general_ci NULL,
    PRIMARY KEY (`id`),
    KEY `K_azdoCollectionId`(`azdoCollectionId`, `removedDate`),
    KEY `FK_azdoIntegrationId`(`azdoIntegrationId`),
    CONSTRAINT `FK_azdoIntegrationId`
    FOREIGN KEY (`azdoIntegrationId`) REFERENCES `bolt_azdoIntegrationProperties` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET='utf8' COLLATE='utf8_general_ci';

/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;