const { transpileFiles, transpileFile, getAllFilesInFolder } = require('./transpileCommon');

function transpile(inputPath, outputPath, relativeFiles){

    try {
        files = relativeFiles;

        if (files.length === 0) {
            allFiles = getAllFilesInFolder(inputPath);
            files = filterFiles(allFiles);
        }

        return transpileFiles(inputPath, files, outputPath);
    }
    catch(error){
        console.log(`Transpilation failed on folder ${inputPath}: ${error.message}`);
        return -1;
    }
}


function filterFiles(files){

    const result = [];

    const includeFilter = "\\.(jsx|ts|tsx|mts|js|cjs|mjs|cts)$";
    const excludeFilter = "(node_modules)";

    for (const file of files){
        if (file.match(includeFilter) && !file.match(excludeFilter)){
            result.push(file);
        }
    }

    return result;
}


const arguments = process.argv.slice(2);
const inputPath = arguments[0];
console.log(`inputPath: ${inputPath}`);

const outputPath = arguments[1];
console.log(`outputPath: ${outputPath}`);

const relativeFiles = arguments.slice(2);
console.log(`Num of relativeFiles: ${relativeFiles.length}`);

if (relativeFiles.length === 1){
    console.log(`relativeFile: ${relativeFiles[0]}`);
}

const exitCode = transpile(inputPath, outputPath, relativeFiles);
process.exit(exitCode);
