import argparse
import glob
import os


def get_all_files(directory, extension):
    return [f for f in glob.glob(directory + "**/*" + extension, recursive=True)]


def read_file(content_file):
    with open(content_file, "r") as file:
        return file.read()


def appender():
    parser = argparse.ArgumentParser()
    parser.add_argument("content_file")
    parser.add_argument("directory")
    parser.add_argument("extension")
    args = parser.parse_args()
    files = get_all_files(args.directory, args.extension)
    content = read_file(args.content_file)
    for f in files:
        with open(f, "a") as file_appender:
            file_appender.write(os.linesep)
            file_appender.write(content)


if __name__ == '__main__':
    appender()
