/*
 * Decompiled with CFR 0.152.
 */
package com.whitesource.bitbucket.plugin;

import Manager.PluginConfigurationManager;
import Manager.PluginConfigurationManagerSingleton;
import Manager.ProjectServiceManager;
import Manager.RepositoryHookServiceManager;
import Manager.RepositoryServiceManager;
import activeObject.RepoVulInfoService;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.hook.repository.RepositoryHook;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.gson.JsonObject;
import com.whitesource.bitbucket.plugin.AbstractServlet;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import models.ExtendedProject;
import models.ExtendedRepository;
import models.MessageType;
import models.WebhookSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.JsonUtils;
import utils.StringUtils;

public class ProjectServlet
extends AbstractServlet {
    private static final Logger logger = LoggerFactory.getLogger(ProjectServlet.class);
    private static final String CONFIGURATION_MESSAGE = "configurationMessage";
    private static final String REPOSITORIES = "repositories";
    private static final String PROJECT = "project";
    private static final String ALL_REPOSITORIES_INDICATOR = "allRepositoriesIndicator";
    private final PluginConfigurationManager pluginConfigurationManager;
    private final RepoVulInfoService repoVulInfoService;
    private final AuthenticationContext authenticationContext;

    @Inject
    public ProjectServlet(SoyTemplateRenderer soyTemplateRenderer, RepoVulInfoService repoVulInfoService, AuthenticationContext authenticationContext) {
        super(soyTemplateRenderer);
        this.repoVulInfoService = repoVulInfoService;
        this.pluginConfigurationManager = PluginConfigurationManagerSingleton.getInstance();
        this.authenticationContext = authenticationContext;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean authenticatedRequest = this.authenticationContext.isAuthenticated();
        if (!authenticatedRequest) {
            response.setStatus(401);
            return;
        }
        String[] requestPathParts = request.getPathInfo().split("/");
        ExtendedProject project = ProjectServiceManager.getProjectFromPath(requestPathParts);
        if (project.getIntegratedProject() == null) {
            response.setStatus(404);
            return;
        }
        List<ExtendedRepository> repositories = RepositoryServiceManager.getAllProjectRepositories(project.getId());
        repositories.sort(Comparator.comparing(ExtendedRepository::getName));
        String configurationMessage = "";
        if ((response.getStatus() == 202 || response.getStatus() == 200 || response.getStatus() == 500) && request.getAttribute(CONFIGURATION_MESSAGE) != null) {
            configurationMessage = (String)request.getAttribute(CONFIGURATION_MESSAGE);
        }
        Boolean allRepositoriesIndicator = project.areAllRepositoriesIncluded();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(REPOSITORIES, repositories);
        map.put(PROJECT, project.getProject());
        map.put(CONFIGURATION_MESSAGE, configurationMessage);
        map.put(ALL_REPOSITORIES_INDICATOR, allRepositoriesIndicator);
        this.render(response, "plugin.whitesource.projectconfigure", map);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean successRemove;
        boolean authenticatedRequest = this.authenticationContext.isAuthenticated();
        if (!authenticatedRequest) {
            response.setStatus(401);
            return;
        }
        String webhookUrl = this.pluginConfigurationManager.getWebhookUrl();
        LinkedList<ExtendedRepository> addedRepos = new LinkedList<ExtendedRepository>();
        LinkedList<ExtendedRepository> removedRepos = new LinkedList<ExtendedRepository>();
        String[] requestPathParts = request.getPathInfo().split("/");
        ExtendedProject project = ProjectServiceManager.getProjectFromPath(requestPathParts);
        if (project.getIntegratedProject() == null) {
            response.setStatus(404);
            return;
        }
        List<ExtendedRepository> repositories = RepositoryServiceManager.getAllProjectRepositories(project.getId());
        boolean enableAllRepositories = this.isEnableAllRepositories(request);
        for (ExtendedRepository extendedRepository : repositories) {
            String parameterName = RepositoryServiceManager.getExtendFullRepoName(extendedRepository.getRepository(), project.getName()) + "Indicator";
            String enableHook = request.getParameter(parameterName);
            RepositoryHook repositoryHook = RepositoryHookServiceManager.getByKey(extendedRepository.getRepository());
            if (!(!enableAllRepositories && !"true".equals(enableHook) || repositoryHook != null && repositoryHook.isEnabled())) {
                addedRepos.add(extendedRepository);
                RepositoryHookServiceManager.enable(extendedRepository.getRepository());
                continue;
            }
            if (!StringUtils.isBlank(enableHook) || repositoryHook == null || !repositoryHook.isEnabled()) continue;
            removedRepos.add(extendedRepository);
            RepositoryHookServiceManager.disable(extendedRepository.getRepository());
        }
        response.setStatus(200);
        boolean successAdd = this.sendWebhook("repositories_added", addedRepos, webhookUrl);
        if (!successAdd) {
            response.setStatus(500);
            RepositoryHookServiceManager.disableHooks(addedRepos);
        }
        if (!(successRemove = this.sendWebhook("repositories_removed", removedRepos, webhookUrl))) {
            response.setStatus(500);
            RepositoryHookServiceManager.enableHooks(removedRepos);
        } else {
            for (ExtendedRepository extendedRepository : removedRepos) {
                String fullRepoName = "";
                try {
                    fullRepoName = RepositoryServiceManager.getFullRepoName(extendedRepository.getRepository());
                    this.repoVulInfoService.deleteIssues(fullRepoName);
                }
                catch (Exception ex) {
                    logger.error("failed to delete issues. fullRepoName: " + fullRepoName, (Throwable)ex);
                }
            }
        }
        MessageType messageType = null;
        if (!successAdd || !successRemove) {
            messageType = MessageType.FAILED;
        } else if (!addedRepos.isEmpty()) {
            messageType = MessageType.SCANNING;
        } else if (!removedRepos.isEmpty()) {
            messageType = MessageType.SAVED;
        }
        if (successAdd && successRemove) {
            ProjectServiceManager.updateIncludeAllReposIndication(project.getId(), enableAllRepositories);
            if (messageType == null) {
                messageType = MessageType.SAVED;
            }
        }
        if (messageType != null) {
            request.setAttribute(CONFIGURATION_MESSAGE, (Object)messageType.getMessage());
        }
        this.doGet(request, response);
    }

    private boolean sendWebhook(String propertyName, List<ExtendedRepository> changedRepos, String webhookUrl) {
        JsonObject jsonObject;
        WebhookSender webhookSender;
        boolean success = true;
        if (!changedRepos.isEmpty() && !(webhookSender = new WebhookSender(webhookUrl)).sendWebhookUpdate((jsonObject = JsonUtils.getAddedOrRemovedRepositoriesToJson(propertyName, changedRepos, this.authenticationContext.getCurrentUser(), true)).toString(), "installation_repositories")) {
            success = false;
        }
        return success;
    }

    private boolean isEnableAllRepositories(HttpServletRequest request) {
        boolean result = true;
        String[] values = request.getParameterValues(REPOSITORIES);
        if (values != null) {
            for (String value : values) {
                if ("true".equals(value)) continue;
                result = false;
                break;
            }
        } else {
            result = false;
        }
        return result;
    }
}

