/*
 * Decompiled with CFR 0.152.
 */
package com.whitesource.bitbucket.plugin;

import Manager.PluginConfigurationManagerSingleton;
import Manager.ProjectServiceManager;
import Manager.RepositoryHookServiceManager;
import Manager.RepositoryServiceManager;
import activeObject.RepoVulInfoServiceImpl;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bitbucket.event.hook.RepositoryHookDisabledEvent;
import com.atlassian.bitbucket.event.hook.RepositoryHookEnabledEvent;
import com.atlassian.bitbucket.event.project.ProjectCreatedEvent;
import com.atlassian.bitbucket.event.project.ProjectDeletedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryCreatedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryDeletedEvent;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.whitesource.bitbucket.plugin.ConfigurationProgress;
import com.whitesource.bitbucket.plugin.ConfigureServlet;
import com.whitesource.bitbucket.plugin.PluginEventsListener;
import java.util.LinkedList;
import javax.inject.Named;
import models.ExtendedProject;
import models.ExtendedRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import utils.SendingUtils;

@Named(value="initAndDestroyNotifier")
public class DestroyNotifier
implements DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(DestroyNotifier.class);
    private static final String INSTALLATION_REPOSITORIES = "installation_repositories";
    private ActiveObjects activeObjects;
    private PluginEventManager pluginEventManager;

    @EventListener
    public void onRepositoryHookEnabledEvent(RepositoryHookEnabledEvent repositoryHookEnabledEvent) {
        logger.info("DestroyNotifier.onRepositoryHookEnabledEvent has been called");
        if (this.activateRepositoryHookEvent(repositoryHookEnabledEvent.getRepositoryHookKey())) {
            Repository repository = ((RepositoryScope)repositoryHookEnabledEvent.getScope()).getRepository();
            LinkedList<ExtendedRepository> repositories = new LinkedList<ExtendedRepository>();
            repositories.add(new ExtendedRepository(repository));
            SendingUtils.sendUpdateOnEnabledOrDisabledEvent(repositories, INSTALLATION_REPOSITORIES, "repositories_added", repositoryHookEnabledEvent.getUser(), true);
        }
    }

    @EventListener
    public void onRepositoryHookDisabledEvent(RepositoryHookDisabledEvent repositoryHookDisabledEvent) {
        logger.info("DestroyNotifier.onRepositoryHookDisabledEvent has been called");
        if (this.activateRepositoryHookEvent(repositoryHookDisabledEvent.getRepositoryHookKey())) {
            Repository repository = ((RepositoryScope)repositoryHookDisabledEvent.getScope()).getRepository();
            ProjectServiceManager.updateIncludeAllReposIndication(repository.getProject().getId(), false);
            LinkedList<ExtendedRepository> repositories = new LinkedList<ExtendedRepository>();
            repositories.add(new ExtendedRepository(repository));
            SendingUtils.sendUpdateOnEnabledOrDisabledEvent(repositories, INSTALLATION_REPOSITORIES, "repositories_removed", repositoryHookDisabledEvent.getUser(), true);
        }
    }

    @EventListener
    public void onRepositoryCreatedEvent(RepositoryCreatedEvent repositoryCreatedEvent) {
        logger.info("DestroyNotifier.onRepositoryCreatedEvent has been called");
        ExtendedProject project = ProjectServiceManager.getExtendedProject(repositoryCreatedEvent.getRepository().getProject());
        if (project.areAllRepositoriesIncluded()) {
            Repository repository = repositoryCreatedEvent.getRepository();
            RepositoryHookServiceManager.enable(repository);
        }
    }

    @EventListener
    public void onRepositoryDeletedEvent(RepositoryDeletedEvent repositoryDeletedEvent) {
        logger.info("DestroyNotifier.onRepositoryDeletedEvent has been called");
        RepoVulInfoServiceImpl repoVulInfoService = new RepoVulInfoServiceImpl(this.activeObjects);
        Repository repository = repositoryDeletedEvent.getRepository();
        String fullRepoName = RepositoryServiceManager.getFullRepoName(repository);
        repoVulInfoService.deleteIssues(fullRepoName);
        LinkedList<ExtendedRepository> repositories = new LinkedList<ExtendedRepository>();
        repositories.add(new ExtendedRepository(repository));
        SendingUtils.sendUpdateOnEnabledOrDisabledEvent(repositories, INSTALLATION_REPOSITORIES, "repositories_removed", repositoryDeletedEvent.getUser(), true);
    }

    @EventListener
    public void onProjectCreatedEvent(ProjectCreatedEvent projectCreatedEvent) {
        logger.info("DestroyNotifier.onProjectCreatedEvent has been called");
        if (PluginConfigurationManagerSingleton.getInstance().isAllProjects().booleanValue()) {
            ProjectServiceManager.addIntegratedProject(projectCreatedEvent.getProject().getId(), false);
        }
    }

    @EventListener
    public void onProjectDeletedEvent(ProjectDeletedEvent projectDeletedEvent) {
        logger.info("DestroyNotifier.onProjectDeletedEvent has been called");
        ProjectServiceManager.removeIntegratedProject(projectDeletedEvent.getProject().getId());
    }

    public void destroy() {
        logger.info("DestroyNotifier.destroy has been called");
    }

    private boolean activateRepositoryHookEvent(String hookName) {
        boolean activate = false;
        if (ConfigureServlet.getConfigurationProgress() != ConfigurationProgress.IN_PROGRESS && RepositoryHookServiceManager.getPushHookName().equals(hookName)) {
            activate = true;
        }
        return activate;
    }

    public void setActiveObjects(ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    public void setPluginEventManager(PluginEventManager pluginEventManager) {
        this.pluginEventManager = pluginEventManager;
        PluginEventsListener.install(pluginEventManager, this.activeObjects);
    }
}

