/*
 * Decompiled with CFR 0.152.
 */
package Manager;

import Manager.ProjectServiceManager;
import Manager.RepositoryServiceManager;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.bitbucket.util.UncheckedOperation;
import java.util.List;
import models.ExtendedProject;
import models.ExtendedRepository;

public class SecurityServiceManager {
    private static SecurityService securityService;

    public static SecurityService getSecurityService() {
        return securityService;
    }

    public static List<ExtendedProject> getIntegratedProjectsFromSecurityContext() {
        return (List)securityService.withPermission(Permission.ADMIN, "Get all projects for Mend integration").call((Operation)new UncheckedOperation<List<ExtendedProject>>(){

            public List<ExtendedProject> perform() {
                return ProjectServiceManager.getIntegratedProjects();
            }
        });
    }

    public static List<ExtendedRepository> getIntegratedReposFromSecurityContext(final int projectId) {
        return (List)securityService.withPermission(Permission.ADMIN, "Get all project repos for Mend integration").call((Operation)new UncheckedOperation<List<ExtendedRepository>>(){

            public List<ExtendedRepository> perform() {
                return RepositoryServiceManager.getIntegratedProjectRepositories(projectId);
            }
        });
    }

    public void setSecurityService(SecurityService securityService) {
        SecurityServiceManager.securityService = securityService;
    }
}

