/*
 * Decompiled with CFR 0.152.
 */
package Manager;

import Manager.RepositoryHookServiceManager;
import Manager.SecurityServiceManager;
import com.atlassian.bitbucket.hook.repository.RepositoryHook;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryCloneLinksRequest;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.util.NamedLink;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageRequestImpl;
import com.atlassian.bitbucket.util.UncheckedOperation;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import models.ExtendedRepository;

public class RepositoryServiceManager {
    private static RepositoryService repositoryService;

    public static List<ExtendedRepository> getAllProjectRepositories(Integer projectId) {
        return RepositoryServiceManager.getProjectRepositories(projectId, false, false);
    }

    public static List<ExtendedRepository> getIntegratedProjectRepositories(Integer projectId) {
        return RepositoryServiceManager.getProjectRepositories(projectId, false, true);
    }

    public static boolean doesProjectHaveIntegratedRepos(Integer projectId) {
        List<ExtendedRepository> repos = RepositoryServiceManager.getProjectRepositories(projectId, true, true);
        return !repos.isEmpty();
    }

    public static List<ExtendedRepository> getIntegratedRepositories() {
        LinkedList<ExtendedRepository> result = new LinkedList<ExtendedRepository>();
        boolean isLastPage = false;
        PageRequestImpl pageRequest = new PageRequestImpl(0, 1000);
        while (!isLastPage) {
            Page repositoryPage = repositoryService.findAll((PageRequest)pageRequest);
            isLastPage = repositoryPage.getIsLastPage();
            pageRequest = repositoryPage.getNextPageRequest();
            for (Repository repository : repositoryPage.getValues()) {
                ExtendedRepository extendedRepository = new ExtendedRepository(repository);
                RepositoryHook repositoryHook = RepositoryHookServiceManager.getByKey(repository);
                if (repositoryHook == null || !repositoryHook.isEnabled()) continue;
                extendedRepository.setChecked(true);
                result.add(extendedRepository);
            }
        }
        return result;
    }

    public static Set<NamedLink> getCloneLinks(final RepositoryCloneLinksRequest cloneLinksRequest) {
        return (Set)SecurityServiceManager.getSecurityService().withPermission(Permission.REPO_ADMIN, "Get clone links for repository " + cloneLinksRequest.getRepository().getName()).call((Operation)new UncheckedOperation<Set<NamedLink>>(){

            public Set<NamedLink> perform() {
                return repositoryService.getCloneLinks(cloneLinksRequest);
            }
        });
    }

    public static Repository getBySlug(String projectKey, String slug) {
        return repositoryService.getBySlug(projectKey, slug);
    }

    public static String getFullRepoName(Repository repository) {
        if (repository == null) {
            return null;
        }
        return repository.getProject().getName() + "/" + repository.getName();
    }

    public static String getExtendFullRepoName(Repository repository, String projectName) {
        if (repository == null) {
            return null;
        }
        return projectName + "/" + repository.getName();
    }

    public static String getFullRepoNameForServer(Repository repository) {
        return repository.getProject().getKey() + "/" + repository.getSlug();
    }

    public static Repository getRepoFromPath(String path) {
        String[] components = path.split("/");
        return RepositoryServiceManager.getRepoFromPath(components);
    }

    public static Repository getRepoFromPath(final String[] components) {
        Repository repository = components == null || components.length < 3 ? null : (Repository)SecurityServiceManager.getSecurityService().withPermission(Permission.REPO_ADMIN, "Find Repository from path").call((Operation)new UncheckedOperation<Repository>(){

            public Repository perform() {
                return RepositoryServiceManager.getBySlug(components[1], components[2]);
            }
        });
        return repository;
    }

    public RepositoryService getRepositoryService() {
        return repositoryService;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        RepositoryServiceManager.repositoryService = repositoryService;
    }

    private static List<ExtendedRepository> getProjectRepositories(Integer projectId, boolean returnIfOneHookExists, boolean onlyIncludeIntegratedRepos) {
        LinkedList<ExtendedRepository> result = new LinkedList<ExtendedRepository>();
        boolean isLastPage = false;
        PageRequestImpl pageRequest = new PageRequestImpl(0, 1000);
        while (!isLastPage) {
            Page repositoryPage = repositoryService.findByProjectId(projectId.intValue(), (PageRequest)pageRequest);
            isLastPage = repositoryPage.getIsLastPage();
            pageRequest = repositoryPage.getNextPageRequest();
            for (Repository repository : repositoryPage.getValues()) {
                ExtendedRepository extendedRepository = new ExtendedRepository(repository);
                RepositoryHook repositoryHook = RepositoryHookServiceManager.getByKey(repository);
                if (repositoryHook != null && repositoryHook.isEnabled()) {
                    extendedRepository.setChecked(true);
                    result.add(extendedRepository);
                    if (!returnIfOneHookExists) continue;
                    return result;
                }
                if (returnIfOneHookExists || onlyIncludeIntegratedRepos) continue;
                result.add(extendedRepository);
            }
        }
        return result;
    }
}

