/**
 * This is a Babel plugin that clears the ast from ES6 features that are redundant for VIA analysis (e.g. *(regenerator), yield, async)
 * More information about babel plugins can be found here:
 * https://github.com/jamiebuilds/babel-handbook/blob/master/translations/en/plugin-handbook.md
 * The following site can be use to find out how Babel's AST looks like:
 * https://astexplorer.net/
 */
exports.__esModule = true;
exports.default = _default;


function _default({types: t}) {
    return {
        visitor: {
            FunctionDeclaration(path) {
                path.node.generator = false;
                path.node.async = false;
            },
            YieldExpression(path) {
                let newNode = t.EmptyStatement();
                if (path.node.argument) {
                    newNode = path.node.argument;
                }
                path.replaceWith(newNode);
            },
            FunctionExpression(path) {
                path.node.generator = false;
                //path.node.async = false;
            },
            AwaitExpression(path) {
                path.replaceWith(path.node.argument)
            }
        }
    };
}
