/*
 * Decompiled with CFR 0.152.
 */
package com.whitesource.bitbucket.plugin;

import Manager.BranchServiceManager;
import Manager.PluginConfigurationManager;
import Manager.PluginConfigurationManagerSingleton;
import Manager.ProjectServiceManager;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.hook.repository.PostRepositoryHook;
import com.atlassian.bitbucket.hook.repository.PostRepositoryHookContext;
import com.atlassian.bitbucket.hook.repository.PullRequestMergeHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.StandardRepositoryHookTrigger;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import jakarta.annotation.PostConstruct;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import models.WebhookSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.ConvertUtils;

public class PushPostRepositoryHook
implements PostRepositoryHook<RepositoryHookRequest> {
    private static final Logger logger = LoggerFactory.getLogger(PushPostRepositoryHook.class);
    private static final String REPO_REFS_CHANGED = "repo:refs_changed";
    private static final String PULL_REQUEST_FULFILLED = "pullrequest:fulfilled";
    private static final String EVENT_KEY = "eventKey";
    private static final String ACTOR = "actor";
    private static final String REPOSITORY = "repository";
    private static final String CHANGES = "changes";
    private static final String PULL_REQUEST = "pullRequest";
    private static final String INSTALLATION_REPOSITORIES = "installation_repositories";
    private static final String REPOSITORIES_ADDED = "repositories_added";
    private final PluginConfigurationManager pluginConfigurationManager;
    private final AuthenticationContext authenticationContext;

    @Inject
    public PushPostRepositoryHook(AuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
        this.pluginConfigurationManager = PluginConfigurationManagerSingleton.getInstance();
    }

    @PostConstruct
    public void updateOnEnableRepositories() {
        ProjectServiceManager.migrateToProjectBasedIntegration();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void postUpdate(@Nonnull PostRepositoryHookContext context, @Nonnull RepositoryHookRequest hookRequest) {
        try {
            String trigger = hookRequest.getTrigger().getId().toLowerCase();
            if (!trigger.equals(StandardRepositoryHookTrigger.FILE_EDIT.getId().toLowerCase()) && !trigger.equals(StandardRepositoryHookTrigger.REPO_PUSH.getId().toLowerCase())) {
                if (!trigger.equals(StandardRepositoryHookTrigger.PULL_REQUEST_MERGE.getId().toLowerCase())) return;
            }
            trigger = REPO_REFS_CHANGED;
            WebhookSender webhookSender = new WebhookSender(this.pluginConfigurationManager.getWebhookUrl());
            boolean sendSucceeded = webhookSender.sendWebhookUpdate(this.buildPushPayload(hookRequest).toString(), trigger);
            if (hookRequest instanceof PullRequestMergeHookRequest) {
                trigger = PULL_REQUEST_FULFILLED;
                if (!sendSucceeded) return;
                if (!webhookSender.sendWebhookUpdate(this.buildMergeRequestPayload((PullRequestMergeHookRequest)hookRequest).toString(), trigger)) return;
                return;
            }
            if (sendSucceeded) return;
        }
        catch (Exception ex) {
            logger.error("Failed to send push webhook", (Throwable)ex);
        }
    }

    private JsonObject buildPushPayload(RepositoryHookRequest hookRequest) {
        Gson gson = new Gson();
        JsonObject result = new JsonObject();
        result.addProperty(EVENT_KEY, REPO_REFS_CHANGED);
        result.add(ACTOR, gson.toJsonTree(ConvertUtils.convertToActorDto(this.authenticationContext.getCurrentUser())));
        result.add(REPOSITORY, gson.toJsonTree(ConvertUtils.convertToRepositoryDto(hookRequest.getRepository(), BranchServiceManager.getDefaultBranch(hookRequest.getRepository()), this.authenticationContext.getCurrentUser())));
        result.add(CHANGES, gson.toJsonTree(ConvertUtils.convertToChangesDto(hookRequest.getRefChanges(), hookRequest.getRepository())));
        return result;
    }

    private JsonObject buildMergeRequestPayload(PullRequestMergeHookRequest hookRequest) {
        Gson gson = new Gson();
        JsonObject result = new JsonObject();
        result.addProperty(EVENT_KEY, PULL_REQUEST_FULFILLED);
        result.add(ACTOR, gson.toJsonTree(ConvertUtils.convertToActorDto(this.authenticationContext.getCurrentUser())));
        result.add(REPOSITORY, gson.toJsonTree(ConvertUtils.convertToRepositoryDto(hookRequest.getRepository(), BranchServiceManager.getDefaultBranch(hookRequest.getRepository()), this.authenticationContext.getCurrentUser())));
        result.add(PULL_REQUEST, gson.toJsonTree(ConvertUtils.convertToPullRequestDto(hookRequest.getPullRequest())));
        return result;
    }
}

