/*
 * Decompiled with CFR 0.152.
 */
package com.whitesource.bitbucket.plugin;

import LicenseKey.LicenseKeyUtils;
import LicenseKey.LicenseParameters;
import LicenseKey.LicenseResultType;
import Manager.PluginConfigurationManager;
import Manager.PluginConfigurationManagerSingleton;
import Manager.ProjectServiceManager;
import Manager.RepositoryHookServiceManager;
import Manager.RepositoryServiceManager;
import activeObject.IntegratedProject;
import activeObject.RepoVulInfoService;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.whitesource.bitbucket.plugin.AbstractServlet;
import com.whitesource.bitbucket.plugin.ConfigurationProgress;
import httpUtils.HttpClient;
import httpUtils.HttpResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import models.ActivationType;
import models.AgentConfigurationResponse;
import models.ExtendedProject;
import models.ExtendedRepository;
import models.MessageType;
import models.WebhookSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.AesCrypto;
import utils.JsonUtils;
import utils.StringUtils;

public class ConfigureServlet
extends AbstractServlet {
    private static final Logger logger = LoggerFactory.getLogger(ConfigureServlet.class);
    private static final String CONFIGURATION_MESSAGE = "configurationMessage";
    private static final String PROJECTS = "projects";
    private static final String ACTIVATION_KEY = "activationKey";
    private static final String HEALTHCHECK_PREFIX_URL = "/healthcheck";
    private static final String OK_RESPONSE_CODE = "200";
    private static final String ACTIVATION_MESSAGE = "activationMessage";
    private static final String ALL_PROJECTS_INDICATOR = "allProjectsIndicator";
    private static final String DISABLE_SAVE_BUTTON = "disableSaveButton";
    private static ConfigurationProgress configurationProgress = ConfigurationProgress.NONE;
    private static String configurationProgressMessage = "";
    private final PluginConfigurationManager pluginConfigurationManager;
    private final RepoVulInfoService repoVulInfoService;
    private List<ExtendedProject> allProjects = new LinkedList<ExtendedProject>();
    private final AuthenticationContext authenticationContext;

    @Inject
    public ConfigureServlet(SoyTemplateRenderer soyTemplateRenderer, RepoVulInfoService repoVulInfoService, AuthenticationContext authenticationContext) {
        super(soyTemplateRenderer);
        this.repoVulInfoService = repoVulInfoService;
        this.pluginConfigurationManager = PluginConfigurationManagerSingleton.getInstance();
        this.authenticationContext = authenticationContext;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean authenticatedRequest = this.authenticationContext.isAuthenticated();
        if (authenticatedRequest) {
            List<ExtendedProject> projects = ProjectServiceManager.getAllProjects();
            this.allProjects = projects;
            String activationKey = this.pluginConfigurationManager.getActivationKey();
            if (activationKey == null) {
                activationKey = "";
            }
            String activationKeyMessage = "";
            Object configurationMessage = "";
            if (response.getStatus() == 202 || (response.getStatus() == 200 || response.getStatus() == 500) && StringUtils.isNotBlank(activationKey)) {
                activationKeyMessage = ActivationType.VALID.getMessage();
                if (request.getAttribute(CONFIGURATION_MESSAGE) != null) {
                    configurationMessage = (String)request.getAttribute(CONFIGURATION_MESSAGE);
                }
            }
            boolean disableSaveButton = false;
            if (ProjectServiceManager.isMigrationRunning()) {
                configurationMessage = MessageType.MIGRATION_IN_PROGRESS.getMessage();
                String migrationStatus = ProjectServiceManager.getMigrationStatusMessage();
                if (StringUtils.isNotBlank(migrationStatus)) {
                    configurationMessage = (String)configurationMessage + " \n" + migrationStatus;
                }
                disableSaveButton = true;
            } else if (configurationProgress == ConfigurationProgress.IN_PROGRESS) {
                configurationMessage = MessageType.CONFIGURATION_IN_PROGRESS.getMessage();
                if (StringUtils.isNotBlank(configurationProgressMessage)) {
                    configurationMessage = (String)configurationMessage + " \n" + configurationProgressMessage;
                }
                disableSaveButton = true;
            } else if (configurationProgress == ConfigurationProgress.DONE) {
                configurationMessage = MessageType.SAVED.getMessage();
                configurationProgress = ConfigurationProgress.NONE;
                if (StringUtils.isNotBlank(configurationProgressMessage)) {
                    configurationMessage = (String)configurationMessage + " \n" + configurationProgressMessage;
                    configurationProgressMessage = "";
                }
            } else if (configurationProgress == ConfigurationProgress.FAILED) {
                configurationMessage = MessageType.FAILED.getMessage();
                configurationProgress = ConfigurationProgress.NONE;
                if (StringUtils.isNotBlank(configurationProgressMessage)) {
                    configurationMessage = (String)configurationMessage + " \n" + configurationProgressMessage;
                    configurationProgressMessage = "";
                }
            }
            Boolean allProjectsIndicator = false;
            if (this.pluginConfigurationManager.isAllProjects() != null) {
                allProjectsIndicator = this.pluginConfigurationManager.isAllProjects();
            }
            if (request.getAttribute(ACTIVATION_MESSAGE) != null) {
                activationKeyMessage = (String)request.getAttribute(ACTIVATION_MESSAGE);
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(PROJECTS, projects);
            map.put(CONFIGURATION_MESSAGE, configurationMessage);
            map.put(ACTIVATION_KEY, activationKey);
            map.put(ACTIVATION_MESSAGE, activationKeyMessage);
            map.put(ALL_PROJECTS_INDICATOR, allProjectsIndicator);
            map.put(DISABLE_SAVE_BUTTON, disableSaveButton);
            this.render(response, "plugin.whitesource.configure", map);
        } else {
            response.setStatus(401);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean authenticatedRequest = this.authenticationContext.isAuthenticated();
        if (authenticatedRequest) {
            String handleActivation = request.getParameter("checkActivateKey");
            if ("true".equals(handleActivation)) {
                String activationKey = request.getParameter("activationKeyTextarea");
                this.handleActivationEvent(activationKey, response, request);
            } else {
                this.handleProjectSelectionEvent(request, response);
            }
            this.doGet(request, response);
        } else {
            response.setStatus(401);
        }
    }

    public static ConfigurationProgress getConfigurationProgress() {
        return configurationProgress;
    }

    private void handleProjectSelectionEvent(HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute(ACTIVATION_MESSAGE, (Object)ActivationType.VALID.getMessage());
        if (configurationProgress == ConfigurationProgress.IN_PROGRESS || ProjectServiceManager.isMigrationRunning()) {
            return;
        }
        configurationProgress = ConfigurationProgress.IN_PROGRESS;
        String webhookUrl = this.pluginConfigurationManager.getWebhookUrl();
        ArrayList<ExtendedProject> projectsToRemove = new ArrayList<ExtendedProject>();
        ArrayList<ExtendedProject> projectsToAdd = new ArrayList<ExtendedProject>();
        boolean enableAllProjects = this.isEnableAllProjects(request);
        for (ExtendedProject extendedProject : this.allProjects) {
            String parameterName = extendedProject.getName() + "Indicator";
            String enableProjectIntegration = request.getParameter(parameterName);
            IntegratedProject integratedProject = extendedProject.getIntegratedProject();
            if ((enableAllProjects || "true".equals(enableProjectIntegration)) && integratedProject == null) {
                projectsToAdd.add(extendedProject);
                continue;
            }
            if (enableAllProjects || !StringUtils.isBlank(enableProjectIntegration) || integratedProject == null) continue;
            projectsToRemove.add(extendedProject);
        }
        response.setStatus(200);
        this.saveProjectConfiguration(projectsToAdd, projectsToRemove, webhookUrl, enableAllProjects);
    }

    private void saveProjectConfiguration(List<ExtendedProject> projectsToAdd, List<ExtendedProject> projectsToRemove, String webhookUrl, boolean enableAllProjects) {
        try {
            configurationProgressMessage = "";
            this.saveProjectConfigurationInternal(projectsToAdd, projectsToRemove, webhookUrl, enableAllProjects);
        }
        catch (Exception ex) {
            logger.error("Configuration change failed.", (Throwable)ex);
            configurationProgress = ConfigurationProgress.FAILED;
        }
    }

    private void saveProjectConfigurationInternal(List<ExtendedProject> projectsToAdd, List<ExtendedProject> projectsToRemove, String webhookUrl, boolean enableAllProjects) {
        try {
            boolean success = this.addProjects(projectsToAdd);
            if (success) {
                success = this.removeProjects(projectsToRemove, webhookUrl);
            }
            if (success) {
                this.pluginConfigurationManager.setAllProjects(enableAllProjects);
                configurationProgress = ConfigurationProgress.DONE;
            } else {
                if (!enableAllProjects) {
                    this.pluginConfigurationManager.setAllProjects(false);
                }
                configurationProgress = ConfigurationProgress.FAILED;
            }
        }
        catch (Exception ex) {
            logger.error("Configuration change failed.", (Throwable)ex);
            configurationProgress = ConfigurationProgress.FAILED;
        }
    }

    private boolean removeProjects(List<ExtendedProject> projectsToRemove, String webhookUrl) {
        int removedProjectsCounter = 0;
        int errorCounter = 0;
        Object initialMessage = configurationProgressMessage;
        if (StringUtils.isNotBlank((String)initialMessage)) {
            initialMessage = (String)initialMessage + "\n";
        }
        for (ExtendedProject projectToRemove : projectsToRemove) {
            block7: {
                try {
                    int projectId = projectToRemove.getId();
                    List<ExtendedRepository> removedRepos = RepositoryServiceManager.getAllProjectRepositories(projectId);
                    removedRepos = removedRepos.stream().filter(ExtendedRepository::isChecked).collect(Collectors.toList());
                    boolean successRemove = this.sendWebhook("repositories_removed", removedRepos, webhookUrl);
                    if (successRemove) {
                        boolean removedAll;
                        if (projectToRemove.getIntegratedProject().getAllRepositoriesIncluded().booleanValue()) {
                            ProjectServiceManager.updateIncludeAllReposIndication(projectId, false);
                        }
                        if (removedAll = this.removeAllReposFromProject(removedRepos)) {
                            ProjectServiceManager.removeIntegratedProject(projectId);
                        }
                        ++removedProjectsCounter;
                        break block7;
                    }
                    configurationProgressMessage = (String)initialMessage + "Webhook URL (from activation key) was unresponsive.";
                    return false;
                }
                catch (Exception ex) {
                    ++errorCounter;
                    logger.error("Failed to remove project from integration. Project key: " + projectToRemove.getKey(), (Throwable)ex);
                }
            }
            configurationProgressMessage = (String)initialMessage + removedProjectsCounter + " projects removed from integration." + (String)(errorCounter == 0 ? "" : " Removal of " + errorCounter + " projects has failed.");
        }
        return errorCounter == 0;
    }

    private boolean removeAllReposFromProject(List<ExtendedRepository> removedRepos) {
        boolean removedAll = true;
        for (ExtendedRepository extendedRepository : removedRepos) {
            String fullRepoName = "";
            try {
                fullRepoName = RepositoryServiceManager.getFullRepoName(extendedRepository.getRepository());
                RepositoryHookServiceManager.disable(extendedRepository.getRepository());
            }
            catch (Exception ex) {
                logger.error("failed to remove repository hook. fullRepoName: " + fullRepoName, (Throwable)ex);
                removedAll = false;
                continue;
            }
            try {
                this.repoVulInfoService.deleteIssues(fullRepoName);
            }
            catch (Exception ex) {
                logger.error("failed to delete issues. fullRepoName: " + fullRepoName, (Throwable)ex);
            }
        }
        return removedAll;
    }

    private boolean addProjects(List<ExtendedProject> projectsToAdd) {
        int addedProjectsCounter = 0;
        int errorCounter = 0;
        for (ExtendedProject projectToAdd : projectsToAdd) {
            try {
                ProjectServiceManager.addIntegratedProject(projectToAdd.getId(), false);
                ++addedProjectsCounter;
            }
            catch (Exception ex) {
                logger.error("Failed to add project to the integration. Project key: " + projectToAdd.getKey(), (Throwable)ex);
                ++errorCounter;
            }
            configurationProgressMessage = addedProjectsCounter + " projects added to integration." + (String)(errorCounter == 0 ? "" : " " + errorCounter + " projects could not be added.");
        }
        return errorCounter == 0;
    }

    private boolean sendWebhook(String propertyName, List<ExtendedRepository> changedRepos, String webhookUrl) {
        JsonObject jsonObject;
        WebhookSender webhookSender;
        boolean success = true;
        if (!changedRepos.isEmpty() && !(webhookSender = new WebhookSender(webhookUrl)).sendWebhookUpdate((jsonObject = JsonUtils.getAddedOrRemovedRepositoriesToJson(propertyName, changedRepos, this.authenticationContext.getCurrentUser(), true)).toString(), "installation_repositories")) {
            success = false;
        }
        return success;
    }

    private boolean isEnableAllProjects(HttpServletRequest request) {
        boolean result = true;
        String[] values = request.getParameterValues(PROJECTS);
        if (values != null) {
            for (String value : values) {
                if ("true".equals(value)) continue;
                result = false;
                break;
            }
        } else {
            result = false;
        }
        return result;
    }

    private void handleActivationEvent(String activationKey, HttpServletResponse response, HttpServletRequest request) {
        ActivationType activationType = ActivationType.INVALID;
        boolean activationFailed = true;
        String webhookUrl = null;
        String personalAccessToken = null;
        LicenseParameters licenseParameters = null;
        if (StringUtils.isNotBlank(activationKey)) {
            try {
                licenseParameters = LicenseKeyUtils.parserLicenseKey(activationKey);
                if (licenseParameters != null && licenseParameters.getStatus() == LicenseResultType.SUCCESS) {
                    HttpResponse getAgentConfigResponse = this.sendGetAgentConfigurationRequest(licenseParameters);
                    if (getAgentConfigResponse != null && getAgentConfigResponse.getResponseCode().equals(OK_RESPONSE_CODE)) {
                        Gson gson = new Gson();
                        AgentConfigurationResponse agentConfiguration = gson.fromJson(getAgentConfigResponse.getResponseBody(), AgentConfigurationResponse.class);
                        if (agentConfiguration != null && agentConfiguration.getConfiguration() != null) {
                            Map<String, String> configuration = this.decryptConfiguration(agentConfiguration.getConfiguration(), licenseParameters.getSecretKey());
                            webhookUrl = configuration.get("webhookUrl");
                            personalAccessToken = configuration.get("accessToken");
                            if (StringUtils.isNotBlank(webhookUrl)) {
                                if (this.checkIfWebhookInterceptorConnected(webhookUrl)) {
                                    activationFailed = false;
                                } else {
                                    activationType = ActivationType.CONNECTION_FAILED_INTERCEPTOR;
                                }
                            }
                        }
                    } else {
                        activationType = ActivationType.CONNECTION_FAILED_APP;
                    }
                }
            }
            catch (Exception e) {
                logger.error("failed to handle activation event.", (Throwable)e);
            }
        }
        if (activationFailed) {
            response.setStatus(403);
            request.setAttribute(ACTIVATION_MESSAGE, (Object)activationType.getMessage());
        } else {
            response.setStatus(202);
            this.pluginConfigurationManager.setActivationKey(activationKey);
            this.pluginConfigurationManager.setWhitesourceOrgToken(licenseParameters.getOrgToken());
            this.pluginConfigurationManager.setWebhookUrl(webhookUrl);
            this.pluginConfigurationManager.setPersonalAccessToken(personalAccessToken);
        }
    }

    private Map<String, String> decryptConfiguration(Map<String, String> mapConfig, String secretKey) throws Exception {
        for (String key : mapConfig.keySet()) {
            String paramValue = mapConfig.get(key);
            if (!paramValue.startsWith("encrypt:")) continue;
            paramValue = paramValue.replace("encrypt:", "");
            paramValue = AesCrypto.decrypt(paramValue, secretKey);
            mapConfig.put(key, paramValue);
        }
        return mapConfig;
    }

    private HttpResponse sendGetAgentConfigurationRequest(LicenseParameters licenseParameters) {
        HttpResponse result;
        HttpClient httpClient = new HttpClient();
        HashMap<String, String> headers = new HashMap<String, String>();
        JsonObject requestJson = new JsonObject();
        requestJson.addProperty("requestType", "getAgentConfiguration");
        requestJson.addProperty("orgToken", licenseParameters.getOrgToken());
        requestJson.addProperty("confVer", licenseParameters.getConfVer());
        requestJson.addProperty("secretKey", licenseParameters.getSecretKey());
        requestJson.addProperty("userKey", licenseParameters.getUserKey());
        requestJson.addProperty("agentType", "bolt-4-op-bitbucket-scanner");
        requestJson.addProperty("agentVersion", "18.12.1");
        headers.put("content-type", "application/json");
        Object urlToSend = "";
        try {
            urlToSend = licenseParameters.getWsEnvIdentifier().replace("\\", "/");
            urlToSend = ((String)urlToSend).substring(0, ((String)urlToSend).lastIndexOf("/")) + "/internal";
            result = httpClient.sendPostRequest((String)urlToSend, headers, -1, -1, false, requestJson.toString());
        }
        catch (IOException e) {
            logger.error("Failed to get agent configuration from WS. URL: " + (String)urlToSend, (Throwable)e);
            result = null;
        }
        return result;
    }

    private boolean checkIfWebhookInterceptorConnected(String webhookUrl) {
        HttpResponse httpResponse;
        String healthCheckUrl = webhookUrl + HEALTHCHECK_PREFIX_URL;
        boolean interceptorConnected = false;
        HttpClient httpClient = new HttpClient();
        HashMap<String, String> headers = new HashMap<String, String>();
        try {
            httpResponse = httpClient.sendGetRequest(healthCheckUrl, null, headers, -1, -1, false);
        }
        catch (IOException e) {
            logger.error("Controller health check failed. URL: " + healthCheckUrl, (Throwable)e);
            httpResponse = null;
        }
        if (httpResponse != null) {
            if (httpResponse.getResponseCode().equals(OK_RESPONSE_CODE)) {
                interceptorConnected = true;
            } else {
                logger.error("Controller health check failed. URL: " + healthCheckUrl + ", responseCode: " + httpResponse.getResponseCode());
            }
        }
        return interceptorConnected;
    }
}

