/*
 * Decompiled with CFR 0.152.
 */
package com.whitesource.bitbucket.plugin;

import Manager.CommitServiceManager;
import Manager.RepositoryServiceManager;
import activeObject.CommitSummaryBuild;
import activeObject.CommitSummaryService;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.gson.JsonObject;
import com.whitesource.bitbucket.plugin.AbstractServlet;
import java.io.IOException;
import java.util.HashMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONObject;
import utils.StringUtils;

public class CommitServlet
extends AbstractServlet {
    public static final String SUMMARY = "summary";
    public static final String REQUEST_TYPE = "requestType";
    private final CommitSummaryService commitSummaryService;
    private final AuthenticationContext authenticationContext;

    @Inject
    public CommitServlet(SoyTemplateRenderer soyTemplateRenderer, CommitSummaryService commitSummaryService, AuthenticationContext authenticationContext) {
        super(soyTemplateRenderer);
        this.commitSummaryService = commitSummaryService;
        this.authenticationContext = authenticationContext;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean authenticatedRequest = this.authenticationContext.isAuthenticated();
        if (authenticatedRequest) {
            Commit commit = CommitServiceManager.getCommitFromPath(request.getPathInfo());
            if (commit == null) {
                response.sendError(404);
                return;
            }
            String commitType = CommitServiceManager.getCommitTypeFromPath(request.getPathInfo(), commit.getId());
            CommitSummaryBuild commitSummaryBuild = this.commitSummaryService.findByRepoCommit(commit.getId() + commitType);
            String summaryHtml = "";
            if (commitSummaryBuild != null && StringUtils.isNotBlank(commitSummaryBuild.getSummaryHtml())) {
                summaryHtml = commitSummaryBuild.getSummaryHtml();
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("repository", RepositoryServiceManager.getRepoFromPath(request.getPathInfo()));
            map.put("summaryHtml", summaryHtml);
            this.render(response, "plugin.whitesource.commit", map);
        } else {
            response.setStatus(401);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean authenticatedRequest = this.authenticationContext.isAuthenticated();
        if (authenticatedRequest) {
            String summaryHtml = null;
            Commit commit = CommitServiceManager.getCommitFromPath(request.getPathInfo());
            String requestBody = request.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
            JSONObject jsonBody = new JSONObject(requestBody);
            if (jsonBody.has(SUMMARY)) {
                summaryHtml = jsonBody.getString(SUMMARY);
                String commitType = CommitServiceManager.getCommitTypeFromPath(request.getPathInfo(), commit.getId());
                this.commitSummaryService.add(commit.getId() + commitType, summaryHtml);
                response.setStatus(200);
            } else if (jsonBody.has(REQUEST_TYPE)) {
                String requestType = jsonBody.getString(REQUEST_TYPE);
                if ("getBuildStatusSummary".equals(requestType)) {
                    JsonObject responseJsonBody = new JsonObject();
                    String commitType = CommitServiceManager.getCommitTypeFromPath(request.getPathInfo(), commit.getId());
                    CommitSummaryBuild commitSummaryBuild = this.commitSummaryService.findByRepoCommit(commit.getId() + commitType);
                    if (commitSummaryBuild != null && StringUtils.isNotBlank(commitSummaryBuild.getSummaryHtml())) {
                        responseJsonBody.addProperty(SUMMARY, commitSummaryBuild.getSummaryHtml());
                    }
                    String jsonToSend = responseJsonBody.toString();
                    response.setStatus(200);
                    response.setContentType("application/json");
                    response.setCharacterEncoding("UTF-8");
                    response.getWriter().write(jsonToSend);
                    response.getWriter().flush();
                    response.getWriter().close();
                } else {
                    response.setStatus(400);
                }
            } else {
                response.setStatus(400);
            }
        } else {
            response.setStatus(401);
        }
    }
}

