/*
 * Decompiled with CFR 0.152.
 */
package Manager;

import com.atlassian.sal.api.pluginsettings.PluginSettings;

public class PluginConfigurationManager {
    private static final String WEBHOOK_URL_KEY = "webhookUrl";
    private static final String WHITESOURCE_ORG_TOKEN = "whitesourceOrgToken";
    private static final String ACTIVATION_KEY = "activationKey";
    private static final String PERSONAL_ACCESS_TOKEN_KEY = "personalAccessToken";
    private static final String ALL_REPOSITORIES = "allRepositories";
    private static final String ALL_PROJECTS = "allProjects";
    private static final String MIGRATION_RAN = "migrationRan";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private PluginSettings pluginSettings;

    public PluginConfigurationManager(PluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }

    public String getWebhookUrl() {
        return (String)this.pluginSettings.get(WEBHOOK_URL_KEY);
    }

    public void setWebhookUrl(String webhookUrl) {
        this.pluginSettings.put(WEBHOOK_URL_KEY, (Object)webhookUrl);
    }

    public String getWhitesourceOrgToken() {
        return (String)this.pluginSettings.get(WHITESOURCE_ORG_TOKEN);
    }

    public void setWhitesourceOrgToken(String whitesourceOrgToken) {
        this.pluginSettings.put(WHITESOURCE_ORG_TOKEN, (Object)whitesourceOrgToken);
    }

    public String getActivationKey() {
        return (String)this.pluginSettings.get(ACTIVATION_KEY);
    }

    public void setActivationKey(String activationKey) {
        this.pluginSettings.put(ACTIVATION_KEY, (Object)activationKey);
    }

    public String getPersonalAccessTokenKey() {
        return (String)this.pluginSettings.get(PERSONAL_ACCESS_TOKEN_KEY);
    }

    public void setPersonalAccessToken(String personalAccessToken) {
        this.pluginSettings.put(PERSONAL_ACCESS_TOKEN_KEY, (Object)personalAccessToken);
    }

    private String getAllRepositories() {
        return (String)this.pluginSettings.get(ALL_REPOSITORIES);
    }

    private void setAllRepositories(String allRepositories) {
        this.pluginSettings.put(ALL_REPOSITORIES, (Object)allRepositories);
    }

    public Boolean isAllRepositories() {
        Boolean result = null;
        String allRepositories = this.getAllRepositories();
        if (TRUE.equals(allRepositories)) {
            result = true;
        } else if (FALSE.equals(allRepositories) || allRepositories == null) {
            result = false;
        }
        return result;
    }

    public void setAllRepositories(Boolean allRepositories) {
        String allRepoResult = FALSE;
        if (allRepositories != null && allRepositories.booleanValue()) {
            allRepoResult = TRUE;
        }
        this.setAllRepositories(allRepoResult);
    }

    private String getAllProjects() {
        return (String)this.pluginSettings.get(ALL_PROJECTS);
    }

    private void setAllProjects(String allProjects) {
        this.pluginSettings.put(ALL_PROJECTS, (Object)allProjects);
    }

    public Boolean isAllProjects() {
        Boolean result = null;
        String allProjects = this.getAllProjects();
        if (TRUE.equals(allProjects)) {
            result = true;
        } else if (FALSE.equals(allProjects) || allProjects == null) {
            result = false;
        }
        return result;
    }

    public void setAllProjects(Boolean isAllProjects) {
        String allProjectsResult = FALSE;
        if (isAllProjects != null && isAllProjects.booleanValue()) {
            allProjectsResult = TRUE;
        }
        this.setAllProjects(allProjectsResult);
    }

    private String getMigrationRan() {
        return (String)this.pluginSettings.get(MIGRATION_RAN);
    }

    private void setMigrationRan(String migrationRan) {
        this.pluginSettings.put(MIGRATION_RAN, (Object)migrationRan);
    }

    public Boolean hasMigrationRan() {
        Boolean result = null;
        String migrationRan = this.getMigrationRan();
        if (TRUE.equals(migrationRan)) {
            result = true;
        } else if (FALSE.equals(migrationRan) || migrationRan == null) {
            result = false;
        }
        return result;
    }

    public void setMigrationRan(Boolean hasMigrationRan) {
        String migrationRanResult = FALSE;
        if (hasMigrationRan != null && hasMigrationRan.booleanValue()) {
            migrationRanResult = TRUE;
        }
        this.setMigrationRan(migrationRanResult);
    }
}

