/*
 * Decompiled with CFR 0.152.
 */
package utils;

import Manager.PropertiesServiceManager;
import Manager.RepositoryServiceManager;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestRef;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryCloneLinksRequest;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.NamedLink;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import models.ActorDto;
import models.BranchDto;
import models.ChangeDto;
import models.CloneDto;
import models.LinksDto;
import models.ProjectDto;
import models.PullRequestDto;
import models.RefDto;
import models.RepositoryDto;

public class ConvertUtils {
    private static String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";

    public static LinksDto convertToLinksDto(Repository repository, ApplicationUser user) {
        LinksDto linksDto = new LinksDto();
        LinkedList<CloneDto> listCloneDto = new LinkedList<CloneDto>();
        for (NamedLink namedLink : ConvertUtils.getCloneDetails(repository, user)) {
            CloneDto cloneDto = new CloneDto();
            cloneDto.setHref(namedLink.getHref());
            cloneDto.setName(namedLink.getName());
            listCloneDto.add(cloneDto);
        }
        linksDto.setClone(listCloneDto);
        return linksDto;
    }

    private static Set<NamedLink> getCloneDetails(Repository repository, ApplicationUser user) {
        RepositoryCloneLinksRequest.Builder cloneLinksRequestBuilder = new RepositoryCloneLinksRequest.Builder();
        cloneLinksRequestBuilder.repository(repository);
        if (user != null) {
            cloneLinksRequestBuilder.user(user);
        }
        RepositoryCloneLinksRequest cloneLinksRequest = cloneLinksRequestBuilder.build();
        return RepositoryServiceManager.getCloneLinks(cloneLinksRequest);
    }

    public static ActorDto convertToActorDto(ApplicationUser user) {
        if (user != null) {
            ActorDto actorDto = new ActorDto();
            actorDto.setActive(user.isActive());
            actorDto.setDisplayName(user.getDisplayName());
            actorDto.setEmailAddress(user.getEmailAddress());
            actorDto.setId(user.getId());
            actorDto.setName(user.getName());
            actorDto.setUser(user.getName());
            actorDto.setSlug(user.getSlug());
            actorDto.setType(user.getType().toString());
            return actorDto;
        }
        return null;
    }

    public static RepositoryDto convertToRepositoryDto(Repository repository, BranchDto defaultBranch, ApplicationUser user) {
        RepositoryDto repositoryDto = new RepositoryDto();
        repositoryDto.setName(repository.getName());
        if (user != null) {
            repositoryDto.setLinks(ConvertUtils.convertToLinksDto(repository, user));
        }
        repositoryDto.setId(repository.getId());
        repositoryDto.setForkable(repository.isForkable());
        repositoryDto.setFullName(RepositoryServiceManager.getFullRepoNameForServer(repository));
        repositoryDto.setScmId(repository.getScmId());
        repositoryDto.setPublic(repository.isPublic());
        repositoryDto.setSlug(repository.getSlug());
        repositoryDto.setState(repository.getState().toString());
        repositoryDto.setStatusMessage(repository.getStatusMessage());
        repositoryDto.setDefaultBranch(defaultBranch);
        ProjectDto projectDto = new ProjectDto();
        Project project = repository.getProject();
        projectDto.setId(project.getId());
        projectDto.setKey(project.getKey());
        projectDto.setName(project.getName());
        projectDto.setPublic(project.isPublic());
        projectDto.setType(project.getType().toString());
        repositoryDto.setProject(projectDto);
        return repositoryDto;
    }

    public static PullRequestDto convertToPullRequestDto(PullRequest pullRequest) {
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
        PullRequestDto pullRequestDto = new PullRequestDto();
        pullRequestDto.setAuthor(ConvertUtils.convertToActorDto(pullRequest.getAuthor().getUser()));
        pullRequestDto.setClosed(pullRequest.isClosed());
        pullRequestDto.setCreatedDate(formatter.format(pullRequest.getCreatedDate()));
        pullRequestDto.setFromRef(ConvertUtils.convertToRefDto(pullRequest.getFromRef()));
        pullRequestDto.setId(Long.valueOf(pullRequest.getId()).intValue());
        pullRequestDto.setLocked(pullRequest.isLocked());
        pullRequestDto.setOpen(pullRequest.isOpen());
        pullRequestDto.setTitle(pullRequest.getTitle());
        pullRequestDto.setToRef(ConvertUtils.convertToRefDto(pullRequest.getToRef()));
        pullRequestDto.setState(pullRequest.getState().name());
        pullRequestDto.setVersion(pullRequest.getVersion());
        pullRequestDto.setUpdatedDate(formatter.format(pullRequest.getUpdatedDate()));
        return pullRequestDto;
    }

    public static List<ChangeDto> convertToChangesDto(Collection<RefChange> changes, Repository repository) {
        LinkedList<ChangeDto> result = new LinkedList<ChangeDto>();
        for (RefChange refChange : changes) {
            result.add(ConvertUtils.convertToChangeDto(refChange, repository));
        }
        return result;
    }

    private static RefDto convertToRefDto(PullRequestRef pullRequestRef) {
        RefDto refDto = new RefDto();
        refDto.setDisplayId(pullRequestRef.getDisplayId());
        refDto.setId(ConvertUtils.getCommitUrl(pullRequestRef.getLatestCommit(), pullRequestRef.getRepository()));
        refDto.setType(pullRequestRef.getType().toString());
        refDto.setRepository(ConvertUtils.convertToRepositoryDto(pullRequestRef.getRepository(), null, null));
        return refDto;
    }

    private static ChangeDto convertToChangeDto(RefChange refChange, Repository repository) {
        ChangeDto changeDto = new ChangeDto();
        changeDto.setFromHash(refChange.getFromHash());
        changeDto.setToHash(refChange.getToHash());
        changeDto.setRefId(refChange.getRef().getId());
        changeDto.setType(refChange.getType().toString());
        RefDto refDto = new RefDto();
        MinimalRef ref = refChange.getRef();
        refDto.setDisplayId(ref.getDisplayId());
        refDto.setId(ConvertUtils.getCommitUrl(refChange.getToHash(), repository));
        refDto.setType(ref.getType().toString());
        changeDto.setRef(refDto);
        return changeDto;
    }

    private static String getCommitUrl(String commitId, Repository repository) {
        Object result = PropertiesServiceManager.getServerUrl();
        result = (String)result + "/projects/" + repository.getProject().getKey() + "/repos/" + repository.getSlug() + "/commits/" + commitId;
        return result;
    }
}

