/*
 * Decompiled with CFR 0.152.
 */
package com.whitesource.bitbucket.plugin;

import Manager.PluginConfigurationManager;
import Manager.PluginConfigurationManagerSingleton;
import com.atlassian.bitbucket.event.pull.PullRequestEvent;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.event.api.EventListener;
import java.util.ArrayList;
import java.util.List;
import models.WebhookSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullRequestListener {
    private static final Logger logger = LoggerFactory.getLogger(PullRequestListener.class);
    private static final String EVENT_KEY = "eventKey";
    private static final String PULL_REQUEST = "pullRequest";
    private static final String ACTOR = "actor";
    private static final String REPOSITORY = "repository";
    private final PluginConfigurationManager pluginConfigurationManager = PluginConfigurationManagerSingleton.getInstance();
    private WebhookSender webhookSender = new WebhookSender(this.pluginConfigurationManager.getWebhookUrl());
    private List<String> events = new ArrayList<String>();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @EventListener
    public void pullRequestOpened(PullRequestEvent prEvent) {
        try {
            String prAction = PullRequestAction.fromId((int)prEvent.getAction().getId()).toString();
            if (!prAction.equals("MERGED") && prAction.startsWith("COMMENTED")) return;
        }
        catch (Exception ex) {
            logger.error("Failed to send pull request webhook", (Throwable)ex);
        }
    }
}

