/*
 * Decompiled with CFR 0.152.
 */
package Manager;

import Manager.SecurityServiceManager;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.NoDefaultBranchException;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.bitbucket.util.UncheckedOperation;
import models.BranchDto;

public class BranchServiceManager {
    private static RefService refService;

    public static BranchDto getDefaultBranch(final Repository repository) {
        BranchDto result = new BranchDto();
        try {
            Branch defaultBranch = (Branch)SecurityServiceManager.getSecurityService().withPermission(Permission.REPO_ADMIN, "Get default branch from repository " + repository.getName()).call((Operation)new UncheckedOperation<Branch>(){

                public Branch perform() {
                    return refService.getDefaultBranch(repository);
                }
            });
            result.setDefault(defaultBranch.getIsDefault());
            result.setDisplayId(defaultBranch.getDisplayId());
            result.setId(defaultBranch.getId());
            result.setLatestCommit(defaultBranch.getLatestCommit());
            result.setType(defaultBranch.getType().toString());
        }
        catch (NoDefaultBranchException e) {
            result = null;
        }
        return result;
    }

    public void setRefService(RefService refService) {
        BranchServiceManager.refService = refService;
    }
}

