package com.wss.scanner.registry.utils.registryHandlers;

import com.wss.common.logging.LogContext;
import com.wss.scanner.registry.models.HostRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;

public abstract class PrivateRegistryFileHandler {
    private final static Logger logger = LoggerFactory.getLogger(PrivateRegistryFileHandler.class);

    public abstract void createRegistryObject(LogContext logContext, String registryObject, List<HostRule> hostRules);

    public abstract void editRegistryObject(LogContext logContext, String registryObject, List<HostRule> hostRules);

    public abstract boolean isProjectLevelRegistryFile();

    public abstract boolean isSystemLevelRegistryFile();

    public abstract boolean isEnvVariableRegistryCredentials();

    public abstract void prepareIncludesAndExcludes(ArrayList<String> includes, ArrayList<String> excludes);

    public abstract List<String> getManifestTypes(String[] localManifestsFiles);

    public abstract List<String> getGlobalRegistryObject(boolean isFile);

    public abstract List<String> getRegistryFileType(String manifestFile);

}