from __future__ import print_function

import argparse
import json
import os.path
import sys

from sources.representation.ARParser import parse


def is_valid_file(parser, arg):
    if not os.path.exists(arg):
        parser.error("Invalid file %s" % arg)
    else:
        return arg


def main():
    parser = argparse.ArgumentParser("Python AR-Parser")
    parser.add_argument("file_path", type=str, help="python file to parse")
    parser.add_argument("imports_file", type=str, help="python file to parse")
    args = parser.parse_args()
    file_path = os.path.realpath(args.file_path)
    imports_file = os.path.realpath(args.imports_file)

    print_parser_results(file_path, imports_file)


def print_parser_results(file_path, imports_file):
    validate_filepath(file_path)
    validate_filepath(imports_file)
    x = parse(file_path, imports_file)

    def printer(x):
        dic = dict(x.__dict__)
        return dic

    print(json.dumps(x, default=printer, indent=4))


def validate_filepath(file_path):
    if not os.path.isfile(file_path):
        print("Could not find file at " + file_path, file=sys.stderr)
        exit(-1)


if __name__ == '__main__':
    main()
