import os
import sys

if sys.platform.startswith("win"):
    import win32api


    def preprocessing_path(path):
        if os.path.exists(path):
            return win32api.GetLongPathName(path)
        return path
else:
    def preprocessing_path(path):
        return path


def to_canonical(path):
    path = preprocessing_path(path)
    return os.path.normcase(os.path.realpath(path))
