import json
import sys

import argparse

from sources.imprecise_analysis.DotsExporter import export_module_dot, is_valid_file


def main():
    parser = argparse.ArgumentParser("Dot Exporter - pydeps ")
    parser.add_argument('-d', '--dir_module', required=True, help="path to app folder",
                        type=lambda x: is_valid_file(parser, x))
    parser.add_argument('-e', '--export_dir', required=True, help="path to dot_export folder",
                        type=lambda x: is_valid_file(parser, x))
    parser.add_argument('-s', '--site_packages', required=True, help="path to site_packages json file",
                        type=lambda x: is_valid_file(parser, x))
    args = parser.parse_args()
    with open(args.site_packages) as f:
        site_packages = json.load(f)
        (app_syntax_error, ext_syntax_error, error) = export_module_dot(args.dir_module, args.export_dir, site_packages)
        if error:
            sys.exit(1)
        if app_syntax_error:
            sys.exit(2)
        if ext_syntax_error:
            sys.exit(3)


if __name__ == '__main__':
    sys.exit(main())
