/*
 * Decompiled with CFR 0.152.
 */
package com.whitesource.bitbucket.plugin;

import Manager.PluginConfigurationManager;
import Manager.PluginConfigurationManagerSingleton;
import Manager.ProjectServiceManager;
import Manager.RepositoryHookServiceManager;
import Manager.RepositoryServiceManager;
import Manager.SecurityServiceManager;
import activeObject.RepoVulInfoService;
import activeObject.RepoVulInfoServiceImpl;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bitbucket.hook.repository.RepositoryHook;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginUninstallingEvent;
import java.util.List;
import models.ExtendedProject;
import models.ExtendedRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.SendingUtils;

public class PluginEventsListener {
    private static final Logger logger = LoggerFactory.getLogger(PluginEventsListener.class);
    private static final String UNINSTALL_PLUGIN = "uninstall_plugin";
    private final PluginConfigurationManager pluginConfigurationManager;
    private final RepoVulInfoService repoVulInfoService;

    private PluginEventsListener(ActiveObjects activeObjects) {
        this.repoVulInfoService = activeObjects == null ? null : new RepoVulInfoServiceImpl(activeObjects);
        this.pluginConfigurationManager = PluginConfigurationManagerSingleton.getInstance();
    }

    public static void install(PluginEventManager pluginEventManager, ActiveObjects activeObjects) {
        pluginEventManager.register((Object)new PluginEventsListener(activeObjects));
    }

    @PluginEventListener
    public void onPluginUninstallingEvent(PluginUninstallingEvent pluginUninstalledEvent) {
        logger.info("PluginEventsListener.onPluginUninstallingEvent has been called");
        if (pluginUninstalledEvent != null && pluginUninstalledEvent.getPlugin() != null && "com.whitesource.bitbucket.server.whitesource-integration".equals(pluginUninstalledEvent.getPlugin().getKey())) {
            String webhookUrl = this.pluginConfigurationManager.getWebhookUrl();
            this.pluginConfigurationManager.setActivationKey(null);
            this.pluginConfigurationManager.setWhitesourceOrgToken(null);
            this.pluginConfigurationManager.setWebhookUrl(null);
            this.pluginConfigurationManager.setPersonalAccessToken(null);
            this.pluginConfigurationManager.setAllRepositories((Boolean)null);
            this.pluginConfigurationManager.setAllProjects((Boolean)null);
            this.pluginConfigurationManager.setMigrationRan((Boolean)null);
            List<ExtendedProject> integratedProjects = SecurityServiceManager.getIntegratedProjectsFromSecurityContext();
            for (ExtendedProject integratedProject : integratedProjects) {
                try {
                    int projectId = integratedProject.getId();
                    List<ExtendedRepository> extendedRepositories = SecurityServiceManager.getIntegratedReposFromSecurityContext(projectId);
                    if (!extendedRepositories.isEmpty()) {
                        SendingUtils.sendUpdateOnEnabledOrDisabledEvent(extendedRepositories, UNINSTALL_PLUGIN, "repositories_removed", null, false, webhookUrl);
                    }
                    for (ExtendedRepository extendedRepository : extendedRepositories) {
                        RepositoryHook repositoryHook = RepositoryHookServiceManager.getByKey(extendedRepository.getRepository());
                        if (repositoryHook == null || !repositoryHook.isEnabled()) continue;
                        RepositoryHookServiceManager.disable(extendedRepository.getRepository());
                        String fullRepoName = RepositoryServiceManager.getFullRepoName(extendedRepository.getRepository());
                        if (this.repoVulInfoService == null) continue;
                        this.repoVulInfoService.deleteIssues(fullRepoName);
                    }
                    ProjectServiceManager.removeIntegratedProject(projectId);
                }
                catch (Exception ex) {
                    logger.error("Failed to uninstall project from Mend integration: " + integratedProject.getKey(), (Throwable)ex);
                }
            }
        }
    }
}

