/*
 * Decompiled with CFR 0.152.
 */
package activeObject;

import activeObject.RepoVulInfo;
import activeObject.RepoVulInfoService;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import models.RepoVulnerabilityObject;
import models.SeverityType;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;

@Named
public class RepoVulInfoServiceImpl
implements RepoVulInfoService {
    @ComponentImport
    private final ActiveObjects activeObjects;

    @Inject
    public RepoVulInfoServiceImpl(ActiveObjects activeObjects) {
        if (activeObjects == null) {
            throw new NullPointerException();
        }
        this.activeObjects = activeObjects;
    }

    @Override
    public RepoVulInfo add(RepoVulnerabilityObject repoVulnerabilityObject) {
        RepoVulInfo result;
        RepoVulInfo foundRepoVulInfo = this.findByRepoNameAndCve(repoVulnerabilityObject.getFullRepoName(), repoVulnerabilityObject.getCve());
        if (foundRepoVulInfo == null) {
            result = (RepoVulInfo)this.activeObjects.create(RepoVulInfo.class, new DBParam[0]);
            result.setFullRepoName(repoVulnerabilityObject.getFullRepoName());
            result.setVulnerability(repoVulnerabilityObject.getHtmlVulnerability());
            result.setCve(repoVulnerabilityObject.getCve());
            result.setSeverity(repoVulnerabilityObject.getSeverity().toString());
            result.save();
        } else {
            result = foundRepoVulInfo;
            result.setVulnerability(repoVulnerabilityObject.getHtmlVulnerability());
            result.save();
        }
        return result;
    }

    @Override
    public RepoVulInfo[] findByRepoName(String fullRepoName) {
        return (RepoVulInfo[])this.activeObjects.find(RepoVulInfo.class, Query.select().where("FULL_REPO_NAME = ?", new Object[]{fullRepoName}));
    }

    @Override
    public RepoVulInfo findByRepoNameAndId(String fullRepoName, Integer id) {
        return (RepoVulInfo)this.activeObjects.get(RepoVulInfo.class, (Object)id);
    }

    @Override
    public List<RepoVulInfo> findByRepoNameAndOrderedBySeverity(String fullRepoName) {
        LinkedList<RepoVulInfo> orderedVulnerabilities = new LinkedList<RepoVulInfo>();
        LinkedList<RepoVulInfo> criticalVulnerabilities = new LinkedList<RepoVulInfo>();
        LinkedList<RepoVulInfo> highVulnerabilities = new LinkedList<RepoVulInfo>();
        LinkedList<RepoVulInfo> mediumVulnerabilities = new LinkedList<RepoVulInfo>();
        LinkedList<RepoVulInfo> lowVulnerabilities = new LinkedList<RepoVulInfo>();
        LinkedList<RepoVulInfo> licenseViolations = new LinkedList<RepoVulInfo>();
        LinkedList<RepoVulInfo> configIssues = new LinkedList<RepoVulInfo>();
        LinkedList<RepoVulInfo> iacIssues = new LinkedList<RepoVulInfo>();
        RepoVulInfo[] allAlerts = this.findByRepoName(fullRepoName);
        if (allAlerts != null && allAlerts.length > 0) {
            block9: for (RepoVulInfo repoVulInfo : allAlerts) {
                SeverityType severityType = SeverityType.valueOf(repoVulInfo.getSeverity());
                switch (severityType) {
                    case LOW: {
                        lowVulnerabilities.add(repoVulInfo);
                        continue block9;
                    }
                    case MEDIUM: {
                        mediumVulnerabilities.add(repoVulInfo);
                        continue block9;
                    }
                    case HIGH: {
                        highVulnerabilities.add(repoVulInfo);
                        continue block9;
                    }
                    case CRITICAL: {
                        criticalVulnerabilities.add(repoVulInfo);
                        continue block9;
                    }
                    case LICENSE: {
                        licenseViolations.add(repoVulInfo);
                        continue block9;
                    }
                    case CONFIG: {
                        configIssues.add(repoVulInfo);
                        continue block9;
                    }
                    case IAC: {
                        iacIssues.add(repoVulInfo);
                    }
                }
            }
        }
        orderedVulnerabilities.addAll(configIssues);
        orderedVulnerabilities.addAll(iacIssues);
        orderedVulnerabilities.addAll(criticalVulnerabilities);
        orderedVulnerabilities.addAll(highVulnerabilities);
        orderedVulnerabilities.addAll(mediumVulnerabilities);
        orderedVulnerabilities.addAll(lowVulnerabilities);
        orderedVulnerabilities.addAll(licenseViolations);
        return orderedVulnerabilities;
    }

    @Override
    public RepoVulInfo findByRepoNameAndCve(String fullRepoName, String cve) {
        RepoVulInfo result = null;
        RepoVulInfo[] repoVulInfoValues = (RepoVulInfo[])this.activeObjects.find(RepoVulInfo.class, Query.select().where("FULL_REPO_NAME = ? AND CVE = ?", new Object[]{fullRepoName, cve}));
        if (repoVulInfoValues != null && repoVulInfoValues.length > 0) {
            result = repoVulInfoValues[0];
        }
        return result;
    }

    @Override
    public void deleteIssues(String fullRepoName) {
        RepoVulInfo[] allRepoIssues = this.findByRepoName(fullRepoName);
        if (allRepoIssues != null) {
            this.activeObjects.delete((RawEntity[])allRepoIssues);
        }
    }

    @Override
    public RepoVulInfo deleteIssue(Integer id) {
        RepoVulInfo issue = (RepoVulInfo)this.activeObjects.get(RepoVulInfo.class, (Object)id);
        if (issue != null) {
            this.activeObjects.delete(new RawEntity[]{issue});
        }
        return issue;
    }
}

