/*
 * Decompiled with CFR 0.152.
 */
package Manager;

import Manager.SecurityServiceManager;
import com.atlassian.bitbucket.hook.repository.DisableRepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.EnableRepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHook;
import com.atlassian.bitbucket.hook.repository.RepositoryHookService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.bitbucket.util.UncheckedOperation;
import java.util.List;
import models.ExtendedRepository;

public class RepositoryHookServiceManager {
    private static final String PUSH_HOOK_NAME = "com.whitesource.bitbucket.server.whitesource-integration:whitesource-push-hook";
    private static RepositoryHookService repositoryHookService;
    private static PermissionValidationService permissionValidationService;

    public static RepositoryHook getByKey(final Repository repository) {
        try {
            permissionValidationService.validateForRepository(repository, Permission.REPO_WRITE);
        }
        catch (Exception ex) {
            return null;
        }
        RepositoryHook repositoryHook = (RepositoryHook)SecurityServiceManager.getSecurityService().withPermission(Permission.ADMIN, "getRepositoryHookByKey").call((Operation)new UncheckedOperation<RepositoryHook>(){

            public RepositoryHook perform() {
                return repositoryHookService.getByKey((Scope)new RepositoryScope(repository), RepositoryHookServiceManager.PUSH_HOOK_NAME);
            }
        });
        return repositoryHook;
    }

    public static void enable(Repository repository) {
        EnableRepositoryHookRequest.Builder builder = new EnableRepositoryHookRequest.Builder((Scope)new RepositoryScope(repository), PUSH_HOOK_NAME);
        repositoryHookService.enable(builder.build());
    }

    public static void disable(Repository repository) {
        DisableRepositoryHookRequest.Builder builder = new DisableRepositoryHookRequest.Builder((Scope)new RepositoryScope(repository), PUSH_HOOK_NAME);
        repositoryHookService.disable(builder.build());
    }

    public static void disableHooks(List<ExtendedRepository> repositories) {
        repositories.forEach(repository -> RepositoryHookServiceManager.disable(repository.getRepository()));
    }

    public static void enableHooks(List<ExtendedRepository> repositories) {
        repositories.forEach(repository -> RepositoryHookServiceManager.enable(repository.getRepository()));
    }

    public static boolean isWhiteSourceHookEnabled(Repository repository) {
        boolean enabled = false;
        RepositoryHook repositoryHook = RepositoryHookServiceManager.getByKey(repository);
        if (repositoryHook != null && repositoryHook.isEnabled()) {
            enabled = true;
        }
        return enabled;
    }

    public void setRepositoryHookService(RepositoryHookService repositoryHookService) {
        RepositoryHookServiceManager.repositoryHookService = repositoryHookService;
    }

    public void setPermissionValidationService(PermissionValidationService permissionValidationService) {
        RepositoryHookServiceManager.permissionValidationService = permissionValidationService;
    }

    public static String getPushHookName() {
        return PUSH_HOOK_NAME;
    }
}

