/*
 * Decompiled with CFR 0.152.
 */
package Manager;

import Manager.RepositoryServiceManager;
import Manager.SecurityServiceManager;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitRequest;
import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.bitbucket.util.UncheckedOperation;

public class CommitServiceManager {
    private static CommitService commitService;

    public static Commit getCommitFromRepoAndId(Repository repository, String commitId) {
        CommitRequest.Builder commitRequestBuilder = new CommitRequest.Builder(repository, commitId);
        CommitRequest commitRequest = commitRequestBuilder.build();
        return commitService.getCommit(commitRequest);
    }

    public static Commit getCommitFromPath(String path) {
        Commit commit;
        final String[] components = path.split("/");
        if (components.length < 4) {
            commit = null;
        } else {
            final Repository repository = RepositoryServiceManager.getRepoFromPath(path);
            commit = (Commit)SecurityServiceManager.getSecurityService().withPermission(Permission.REPO_ADMIN, "Find commit from path").call((Operation)new UncheckedOperation<Commit>(){

                public Commit perform() {
                    return CommitServiceManager.getCommitFromRepoAndId(repository, components[3]);
                }
            });
        }
        return commit;
    }

    public static String getCommitTypeFromPath(String requestPath, String commitId) {
        if (requestPath == null) {
            return "";
        }
        String[] components = requestPath.split("/");
        Object commitType = components[components.length - 1];
        commitType = ((String)commitType).equals(commitId) ? "" : "/" + (String)commitType;
        return commitType;
    }

    public CommitService getCommitService() {
        return commitService;
    }

    public void setCommitService(CommitService commitService) {
        CommitServiceManager.commitService = commitService;
    }
}

