/*
 * Decompiled with CFR 0.152.
 */
package LicenseKey;

import LicenseKey.LicenseParameters;
import LicenseKey.LicenseResultType;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import java.util.Base64;
import java.util.Date;
import java.util.UUID;

public class LicenseKeyUtils {
    private static final String WS_ENVIRONMENT_IDENTIFIER = "wsEnvIdentifier";
    private static final String WS_ORGANIZATION_TOKEN = "orgToken";
    private static final String LICENSE_CREATOR = "iss";
    private static final String LICENSE_CREATION_TIME = "iat";
    private static final String LICENSE_EXPIRATION_TIME = "exp";
    private static final String USER_KET = "userKey";
    private static final String SECRET_KEY = "secretKey";
    private static final String CONFIGURATION_VERSION = "confVer";
    private static final String WHITE_SOURCE_SECRET_KEY = "whiteSourceSecret";

    public static LicenseParameters parserLicenseKey(String licenseKey) throws Exception {
        LicenseParameters params = new LicenseParameters();
        try {
            licenseKey = LicenseKeyUtils.caesarCipherDecrypte(licenseKey);
            Jws<Claims> claims = Jwts.parser().setSigningKey(WHITE_SOURCE_SECRET_KEY.getBytes("UTF-8")).parseClaimsJws(licenseKey);
            if (((Claims)claims.getBody()).containsKey(LICENSE_CREATOR)) {
                params.setIssuerEmail((String)((Claims)claims.getBody()).get(LICENSE_CREATOR));
            }
            if (((Claims)claims.getBody()).containsKey(WS_ENVIRONMENT_IDENTIFIER)) {
                params.setWsEnvIdentifier((String)((Claims)claims.getBody()).get(WS_ENVIRONMENT_IDENTIFIER));
            }
            if (((Claims)claims.getBody()).containsKey(WS_ORGANIZATION_TOKEN)) {
                params.setOrgToken((String)((Claims)claims.getBody()).get(WS_ORGANIZATION_TOKEN));
            }
            if (((Claims)claims.getBody()).containsKey(USER_KET)) {
                params.setUserKey((String)((Claims)claims.getBody()).get(USER_KET));
            }
            if (((Claims)claims.getBody()).containsKey(LICENSE_CREATION_TIME)) {
                params.setIssuedAt(new Date(((Integer)((Claims)claims.getBody()).get(LICENSE_CREATION_TIME)).intValue()));
            }
            if (((Claims)claims.getBody()).containsKey(LICENSE_EXPIRATION_TIME)) {
                params.setExpireAt(new Date(((Integer)((Claims)claims.getBody()).get(LICENSE_EXPIRATION_TIME)).intValue()));
            }
            if (((Claims)claims.getBody()).containsKey(SECRET_KEY)) {
                params.setSecretKey((String)((Claims)claims.getBody()).get(SECRET_KEY));
            }
            if (((Claims)claims.getBody()).containsKey(CONFIGURATION_VERSION)) {
                params.setConfVer((String)((Claims)claims.getBody()).get(CONFIGURATION_VERSION));
            }
            params.setStatus(LicenseResultType.SUCCESS);
            return params;
        }
        catch (ExpiredJwtException ex) {
            params.setStatus(LicenseResultType.INSTALLATION_TIMEOUT);
            return params;
        }
    }

    private static String createRandomUUID() {
        return UUID.randomUUID().toString() + new Date().toString();
    }

    private static String caesarCipherEncrypt(String plain) {
        String b64encoded = Base64.getEncoder().encodeToString(plain.getBytes());
        String reverse = new StringBuffer(b64encoded).reverse().toString();
        StringBuilder tmp = new StringBuilder();
        int OFFSET = 4;
        for (int i = 0; i < reverse.length(); ++i) {
            tmp.append((char)(reverse.charAt(i) + 4));
        }
        return tmp.toString();
    }

    private static String caesarCipherDecrypte(String secret) {
        StringBuilder tmp = new StringBuilder();
        int OFFSET = 4;
        for (int i = 0; i < secret.length(); ++i) {
            tmp.append((char)(secret.charAt(i) - 4));
        }
        String reversed = new StringBuffer(tmp.toString()).reverse().toString();
        return new String(Base64.getDecoder().decode(reversed));
    }
}

