const { transpileFiles, getAllFilesInFolder } = require('./transpileCommon');

function transpile(inputPath, outputPath, sourceFilePatterns, sourceFilesExcludePatterns){

    try {
        const arraySourceFiles= sourceFilePatterns.slice(1, -1).replace(/\s/g, '').split(",");
        const arraySourceFilesExclude=sourceFilesExcludePatterns.slice(1, -1).replace(/\s/g, '').split(",");

        allFiles = getAllFilesInFolder(inputPath);
        files = filterFilesPatterns(allFiles, arraySourceFiles, arraySourceFilesExclude);

        return transpileFiles(inputPath, files, outputPath);
    }
    catch(error){
        console.log(`Transpilation failed on folder ${inputPath}: ${error.message}`);
        return -1;
    }
}
function filterFilesPatterns(files,includeFilter,excludeFilter){

    const result = [];

    const includeRegexArray = includeFilter.map(pattern => new RegExp(pattern));
    const excludeRegExArray = excludeFilter.map(pattern => new RegExp(pattern));

    for (const file of files){
        if(isMatchingPattern(file,includeRegexArray) && !isMatchingPattern(file,excludeRegExArray)){
            result.push(file);
        }
    }

    return result;
}

function isMatchingPattern(file,regexArray){

    return regexArray.some(regex => regex.test(file));

}

const arguments = process.argv.slice(2);
const inputPath = arguments[0];
console.log(`inputPath: ${inputPath}`);

const outputPath = arguments[1];
console.log(`outputPath: ${outputPath}`);

const sourceFilePatterns = arguments[2];
console.log(`sourceFilePatterns: ${sourceFilePatterns}`);

const sourceFilesExcludePatterns = arguments[3];
console.log(`sourceFilesExcludePatterns: ${sourceFilesExcludePatterns}`);

const exitCode = transpile(inputPath, outputPath, sourceFilePatterns, sourceFilesExcludePatterns);
process.exit(exitCode);
