/*
 * Decompiled with CFR 0.152.
 */
package com.wss.container.configModel;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;

public class PropertyOption
implements Serializable {
    private String propertyName;
    private String propertyValue;
    private Collection<String> propertyPaths;

    public PropertyOption() {
        this.propertyPaths = new LinkedList<String>();
    }

    public PropertyOption(String propertyName, String propertyValue, Collection<String> propertyPaths) {
        this.propertyName = propertyName;
        this.propertyValue = propertyValue;
        this.propertyPaths = propertyPaths;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PropertyOption)) {
            return false;
        }
        PropertyOption that = (PropertyOption)o;
        return Objects.equals(this.propertyName, that.propertyName) && Objects.equals(this.propertyValue, that.propertyValue) && Objects.equals(this.propertyPaths, that.propertyPaths);
    }

    public int hashCode() {
        return Objects.hash(this.propertyName, this.propertyValue, this.propertyPaths);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getPropertyValue() {
        String envVariable = System.getenv(this.getPropertyName());
        if (envVariable != null) {
            this.setPropertyValue(envVariable);
        }
        return System.getProperty(this.getPropertyName(), this.propertyValue);
    }

    public void setPropertyValue(String propertyValue) {
        this.propertyValue = propertyValue;
    }

    public Collection<String> getPropertyPaths() {
        return this.propertyPaths;
    }

    public void setPropertyPaths(Collection<String> propertyPaths) {
        this.propertyPaths = propertyPaths;
    }
}

