/*
 * Decompiled with CFR 0.152.
 */
package com.wss.container;

import com.wss.container.PropertiesParser;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class ApplyConfigurations {
    public static void main(String[] args) {
        ApplyConfigurations ac = new ApplyConfigurations();
        ac.applyConfigurations(args);
    }

    protected void applyConfigurations(String[] args) {
        Options options = this.getOptions();
        CommandLine commandLine = this.parseArgs(options, args);
        if (commandLine == null) {
            System.err.println("Could not parse arguments, exiting.");
            System.exit(1);
        }
        if (commandLine.getOptions() == null || commandLine.getOptions().length == 0 || commandLine.hasOption("help")) {
            new HelpFormatter().printHelp("java ApplyConfigurations", options);
            System.exit(0);
        }
        String valuesFilesValue = commandLine.getOptionValue("values-files");
        List<String> valuesFilesPaths = commandLine.getArgList();
        if (valuesFilesPaths.size() == 0 && (valuesFilesValue == null || valuesFilesValue.isEmpty())) {
            System.err.println("Could not find values-files, exiting.");
            System.exit(1);
        }
        boolean preconfigurePropertiesOnly = commandLine.hasOption("preconfigure-only");
        if (valuesFilesValue != null && !valuesFilesValue.isEmpty()) {
            valuesFilesPaths.clear();
            valuesFilesPaths.addAll(Arrays.asList(valuesFilesValue.split(",")));
        }
        PropertiesParser propertiesParser = new PropertiesParser(valuesFilesPaths);
        propertiesParser.injectProperties(preconfigurePropertiesOnly);
        propertiesParser.copyFiles();
    }

    protected CommandLine parseArgs(Options options, String[] args) {
        CommandLine retValue = null;
        try {
            DefaultParser parser = new DefaultParser();
            retValue = parser.parse(options, args);
            return retValue;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected Options getOptions() {
        Options options = new Options();
        options.addOption("h", "help", false, "Print this message");
        options.addOption("v", "values-files", true, "Configuration values json file");
        options.addOption("p", "preconfigure-only", false, "Apply only preconfiguration properties (name starts with \"preconfig_\"");
        return options;
    }
}

