/*
 * Decompiled with CFR 0.152.
 */
package utils;

import Manager.PluginConfigurationManagerSingleton;
import Manager.RepositoryHookServiceManager;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.google.gson.JsonObject;
import java.util.LinkedList;
import java.util.List;
import models.ExtendedRepository;
import models.WebhookSender;
import utils.JsonUtils;
import utils.StringUtils;

public class SendingUtils {
    public static void sendAddedAllEnabledRepos(List<ExtendedRepository> repositories, String bitbucketEventName, String propertyName, ApplicationUser user) {
        LinkedList<ExtendedRepository> changedRepos = new LinkedList<ExtendedRepository>();
        for (ExtendedRepository extendedRepository : repositories) {
            boolean hookEnabled = RepositoryHookServiceManager.isWhiteSourceHookEnabled(extendedRepository.getRepository());
            if (!hookEnabled) continue;
            changedRepos.add(extendedRepository);
        }
        SendingUtils.sendUpdateOnEnabledOrDisabledEvent(changedRepos, bitbucketEventName, propertyName, user, true);
    }

    public static void sendUpdateOnEnabledOrDisabledEvent(List<ExtendedRepository> repositories, String bitbucketEventName, String propertyName, ApplicationUser user, boolean withDefaultBranch) {
        String webhookUrl = PluginConfigurationManagerSingleton.getInstance().getWebhookUrl();
        SendingUtils.sendUpdateOnEnabledOrDisabledEvent(repositories, bitbucketEventName, propertyName, user, withDefaultBranch, webhookUrl);
    }

    public static void sendUpdateOnEnabledOrDisabledEvent(List<ExtendedRepository> repositories, String bitbucketEventName, String propertyName, ApplicationUser user, boolean withDefaultBranch, String webhookUrl) {
        if (StringUtils.isNotBlank(webhookUrl)) {
            WebhookSender webhookSender = new WebhookSender(webhookUrl);
            JsonObject body = JsonUtils.getAddedOrRemovedRepositoriesToJson(propertyName, repositories, user, withDefaultBranch);
            webhookSender.sendWebhookUpdate(body.toString(), bitbucketEventName);
        }
    }
}

